/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit;

import io.github.pronze.lib.screaminglib.CustomPayload;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListenerRegistration;

@Service
public class BukkitCustomPayload
extends CustomPayload {
    private final Plugin plugin;

    @Override
    protected void registerOutgoingChannel0(String channel) {
        Bukkit.getMessenger().registerOutgoingPluginChannel(this.plugin, channel);
    }

    @Override
    protected void unregisterOutgoingChannel0(String channel) {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel(this.plugin, channel);
    }

    @Override
    protected void unregisterAllOutgoingChannels0() {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel(this.plugin);
    }

    @Override
    protected Collection<String> getRegisteredOutgoingChannels0() {
        return Bukkit.getMessenger().getOutgoingChannels(this.plugin);
    }

    @Override
    protected CustomPayload.Registration registerIncomingChannel0(String channel, BiConsumer<PlayerWrapper, byte[]> listener) {
        return new BukkitRegistration(Bukkit.getMessenger().registerIncomingPluginChannel(this.plugin, channel, (channel1, player, message) -> {
            if (channel1.equals(channel)) {
                listener.accept(PlayerMapper.wrapPlayer(player), message);
            }
        }));
    }

    @Override
    protected void unregisterIncomingChannel0(CustomPayload.Registration registration) {
        if (!(registration instanceof BukkitRegistration)) {
            throw new UnsupportedOperationException("Registration is not instance of BukkitRegistration class!");
        }
        PluginMessageListenerRegistration bRegistration = registration.as(PluginMessageListenerRegistration.class);
        Bukkit.getMessenger().unregisterIncomingPluginChannel(bRegistration.getPlugin(), bRegistration.getChannel(), bRegistration.getListener());
    }

    @Override
    protected void unregisterAllIncomingChannels0() {
        Bukkit.getMessenger().unregisterIncomingPluginChannel(this.plugin);
    }

    @Override
    protected Collection<String> getRegisteredIncomingChannels0() {
        return Bukkit.getMessenger().getIncomingChannels(this.plugin);
    }

    @Override
    protected void send0(PlayerWrapper player, String channel, byte[] payload) {
        player.as(Player.class).sendPluginMessage(this.plugin, channel, payload);
    }

    @Override
    protected void send0(String channel, byte[] payload) {
        Bukkit.getServer().sendPluginMessage(this.plugin, channel, payload);
    }

    public BukkitCustomPayload(Plugin plugin) {
        this.plugin = plugin;
    }

    public static class BukkitRegistration
    extends BasicWrapper<PluginMessageListenerRegistration>
    implements CustomPayload.Registration {
        protected BukkitRegistration(PluginMessageListenerRegistration wrappedObject) {
            super(wrappedObject);
        }
    }
}

