/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit;

import io.github.pronze.lib.screaminglib.ItemBlockIdsRemapper;
import io.github.pronze.lib.screaminglib.block.BlockTypeMapper;
import io.github.pronze.lib.screaminglib.item.ItemTypeMapper;
import io.github.pronze.lib.screaminglib.utils.Platform;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import org.bukkit.Bukkit;

@Service
public class BukkitItemBlockIdsRemapper
extends ItemBlockIdsRemapper {
    private static final int versionNumber;
    private static final Platform bPlatform;

    public BukkitItemBlockIdsRemapper(ItemTypeMapper itemTypeMapper, BlockTypeMapper blockTypeMapper) {
        super(itemTypeMapper, blockTypeMapper);
        this.platform = bPlatform;
        if (versionNumber < 112) {
            this.mappingFlags.add(ItemBlockIdsRemapper.MappingFlags.NO_COLORED_BEDS);
        }
    }

    public static int getVersionNumber() {
        return versionNumber;
    }

    public static Platform getBPlatform() {
        return bPlatform;
    }

    static {
        String[] bukkitVersion = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        int ver = 0;
        for (int i = 0; i < 2; ++i) {
            ver += Integer.parseInt(bukkitVersion[i]) * (i == 0 ? 100 : 1);
        }
        versionNumber = ver;
        bPlatform = versionNumber < 113 ? Platform.JAVA_LEGACY : Platform.JAVA_FLATTENING;
    }
}

