/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.block;

import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.bukkit.BukkitCore;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.ClassStorage;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.Unmodifiable;

public class BukkitBlockTypeHolder
extends BasicWrapper<BlockData>
implements BlockTypeHolder {
    public static boolean NAG_AUTHOR_ABOUT_LEGACY_METHOD_USED;
    private static final String NAG_AUTHOR_ABOUT_LEGACY_METHOD_USED_MESSAGE = "Nag author/s of this plugin about usage of BlockTypeHolder#legacyData() or #withLegacyData() in non-legacy environment!";

    public BukkitBlockTypeHolder(Material type) {
        this(type.createBlockData());
        if (!type.isBlock()) {
            throw new UnsupportedOperationException("Material must be a block!");
        }
    }

    public BukkitBlockTypeHolder(BlockData wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public String platformName() {
        return ((BlockData)this.wrappedObject).getMaterial().name();
    }

    @Override
    public byte legacyData() {
        if (!NAG_AUTHOR_ABOUT_LEGACY_METHOD_USED) {
            BukkitCore.getPlugin().getLogger().warning(NAG_AUTHOR_ABOUT_LEGACY_METHOD_USED_MESSAGE);
            NAG_AUTHOR_ABOUT_LEGACY_METHOD_USED = true;
        }
        try {
            Object legacy = Reflect.getMethod(ClassStorage.CB.UNSAFE_EVIL_GET_OUT_getCraftLegacy(), "toLegacyData", Material.class).invokeStatic(((BlockData)this.wrappedObject).getMaterial());
            if (legacy instanceof MaterialData) {
                return ((MaterialData)legacy).getData();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public BlockTypeHolder withLegacyData(byte legacyData) {
        if (!NAG_AUTHOR_ABOUT_LEGACY_METHOD_USED) {
            BukkitCore.getPlugin().getLogger().warning(NAG_AUTHOR_ABOUT_LEGACY_METHOD_USED_MESSAGE);
            NAG_AUTHOR_ABOUT_LEGACY_METHOD_USED = true;
        }
        try {
            Material legacy = Bukkit.getUnsafe().toLegacy(((BlockData)this.wrappedObject).getMaterial());
            if (legacy != null && legacy.isLegacy() && legacy != Material.LEGACY_AIR) {
                return new BukkitBlockTypeHolder(Bukkit.getUnsafe().fromLegacy(legacy, legacyData));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new BukkitBlockTypeHolder(((BlockData)this.wrappedObject).clone());
    }

    @Override
    public @Unmodifiable Map<String, String> flatteningData() {
        String data = ((BlockData)this.wrappedObject).getAsString();
        if (data.contains("[") && data.contains("]")) {
            String values = data.substring(data.indexOf("[") + 1, data.lastIndexOf("]"));
            if (values.isEmpty()) {
                return Map.of();
            }
            return Arrays.stream(values.split(",")).map(next -> next.split("=")).collect(Collectors.toMap(next -> next[0], next1 -> next1[1]));
        }
        return Map.of();
    }

    @Override
    public BlockTypeHolder withFlatteningData(Map<String, String> data) {
        StringBuilder builder = new StringBuilder();
        if (data != null && !data.isEmpty()) {
            builder.append('[');
            builder.append(data.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(",")));
            builder.append(']');
        }
        return new BukkitBlockTypeHolder(((BlockData)this.wrappedObject).getMaterial().createBlockData(builder.toString()));
    }

    @Override
    public BlockTypeHolder with(final String attribute, final String value) {
        return this.withFlatteningData((Map<String, String>)new HashMap<String, String>(this.flatteningData()){
            {
                super(m);
                this.put(attribute, value);
            }
        });
    }

    @Override
    public BlockTypeHolder with(final String attribute, final int value) {
        return this.withFlatteningData((Map<String, String>)new HashMap<String, String>(this.flatteningData()){
            {
                super(m);
                this.put(attribute, String.valueOf(value));
            }
        });
    }

    @Override
    public BlockTypeHolder with(final String attribute, final boolean value) {
        return this.withFlatteningData((Map<String, String>)new HashMap<String, String>(this.flatteningData()){
            {
                super(m);
                this.put(attribute, String.valueOf(value));
            }
        });
    }

    @Override
    public Optional<String> get(String attribute) {
        return Optional.ofNullable(this.flatteningData().get(attribute));
    }

    @Override
    public Optional<Integer> getInt(String attribute) {
        return Optional.ofNullable(this.flatteningData().get(attribute)).flatMap(s -> {
            try {
                return Optional.of(Integer.valueOf(s));
            }
            catch (Throwable ignored) {
                return Optional.empty();
            }
        });
    }

    @Override
    public Optional<Boolean> getBoolean(String attribute) {
        return Optional.ofNullable(this.flatteningData().get(attribute)).map(Boolean::parseBoolean);
    }

    @Override
    public boolean isSolid() {
        return ((BlockData)this.wrappedObject).getMaterial().isSolid();
    }

    @Override
    public boolean isTransparent() {
        return ((BlockData)this.wrappedObject).getMaterial().isTransparent();
    }

    @Override
    public boolean isFlammable() {
        return ((BlockData)this.wrappedObject).getMaterial().isFlammable();
    }

    @Override
    public boolean isBurnable() {
        return ((BlockData)this.wrappedObject).getMaterial().isBurnable();
    }

    @Override
    public boolean isOccluding() {
        return ((BlockData)this.wrappedObject).getMaterial().isOccluding();
    }

    @Override
    public boolean hasGravity() {
        return ((BlockData)this.wrappedObject).getMaterial().hasGravity();
    }

    @Override
    public boolean isSameType(Object object) {
        if (object instanceof Material) {
            return ((BlockData)this.wrappedObject).getMaterial() == object;
        }
        if (object instanceof BukkitBlockTypeHolder) {
            return ((BlockData)this.wrappedObject).getMaterial() == ((BlockData)((BukkitBlockTypeHolder)object).wrappedObject).getMaterial();
        }
        if (object instanceof BlockData) {
            return ((BlockData)this.wrappedObject).getMaterial() == ((BlockData)object).getMaterial();
        }
        return BlockTypeHolder.ofOptional(object).map(h -> h.platformName().equals(this.platformName())).orElse(false);
    }

    @Override
    public boolean isSameType(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::isSameType);
    }

    @Override
    public boolean is(Object object) {
        if (object instanceof BlockData || object instanceof BukkitBlockTypeHolder) {
            return this.equals(object);
        }
        return this.equals(BlockTypeHolder.ofOptional(object).orElse(null));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    public <T> T as(Class<T> type) {
        if (type == Material.class) {
            return (T)((BlockData)this.wrappedObject).getMaterial();
        }
        return super.as(type);
    }
}

