/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.block.state;

import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.block.state.BlockStateHolder;
import io.github.pronze.lib.screaminglib.bukkit.container.BukkitContainer;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.Version;
import io.github.pronze.lib.screaminglib.container.Container;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.InventoryHolder;

public class GenericBlockStateHolder
extends BasicWrapper<BlockState>
implements BlockStateHolder {
    protected GenericBlockStateHolder(BlockState wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public BlockTypeHolder getType() {
        if (!Version.isVersion(1, 13)) {
            return BlockTypeHolder.of(((BlockState)this.wrappedObject).getData());
        }
        return BlockTypeHolder.of(((BlockState)this.wrappedObject).getBlockData());
    }

    @Override
    public void setType(BlockTypeHolder type) {
        if (!Version.isVersion(1, 13)) {
            ((BlockState)this.wrappedObject).setType(type.as(Material.class));
            ((BlockState)this.wrappedObject).setRawData(type.legacyData());
        } else {
            ((BlockState)this.wrappedObject).setBlockData(type.as(BlockData.class));
        }
    }

    @Override
    public LocationHolder getLocation() {
        return LocationMapper.wrapLocation(((BlockState)this.wrappedObject).getLocation());
    }

    @Override
    public boolean updateBlock(boolean force, boolean applyPhysics) {
        return ((BlockState)this.wrappedObject).update(force, applyPhysics);
    }

    @Override
    public boolean holdsInventory() {
        return this.wrappedObject instanceof InventoryHolder;
    }

    @Override
    public Optional<Container> getInventory() {
        if (this.wrappedObject instanceof InventoryHolder) {
            return Optional.of(new BukkitContainer(((InventoryHolder)this.wrappedObject).getInventory()));
        }
        return Optional.empty();
    }
}

