/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.container;

import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItem;
import io.github.pronze.lib.screaminglib.container.Container;
import io.github.pronze.lib.screaminglib.container.type.InventoryTypeHolder;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitContainer
extends BasicWrapper<Inventory>
implements Container {
    public BukkitContainer(Inventory wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public Optional<Item> getItem(int index) {
        ItemStack item = ((Inventory)this.wrappedObject).getItem(index);
        return item == null ? Optional.empty() : Optional.of(new BukkitItem(((Inventory)this.wrappedObject).getItem(index)));
    }

    @Override
    public void setItem(int index, Item item) {
        ((Inventory)this.wrappedObject).setItem(index, item.as(ItemStack.class));
    }

    @Override
    public List<Item> addItem(Item ... items) {
        return ((Inventory)this.wrappedObject).addItem((ItemStack[])Arrays.stream(items).map(item -> item.as(ItemStack.class)).toArray(ItemStack[]::new)).values().stream().filter(Objects::nonNull).map(BukkitItem::new).collect(Collectors.toList());
    }

    @Override
    public List<Item> removeItem(Item ... items) {
        return ((Inventory)this.wrappedObject).removeItem((ItemStack[])Arrays.stream(items).map(item -> item.as(ItemStack.class)).toArray(ItemStack[]::new)).values().stream().filter(Objects::nonNull).map(BukkitItem::new).collect(Collectors.toList());
    }

    @Override
    public @Nullable Item @NotNull [] getContents() {
        Item[] array = new Item[this.getSize()];
        ItemStack[] oldArray = ((Inventory)this.wrappedObject).getContents();
        for (int i = 0; i < this.getSize(); ++i) {
            array[i] = oldArray[i] == null ? null : new BukkitItem(oldArray[i]);
        }
        return array;
    }

    @Override
    public @Nullable Item @NotNull [] getStorageContents() {
        ItemStack[] oldArray = ((Inventory)this.wrappedObject).getStorageContents();
        Item[] array = new Item[oldArray.length];
        for (int i = 0; i < oldArray.length; ++i) {
            array[i] = oldArray[i] == null ? null : new BukkitItem(oldArray[i]);
        }
        return array;
    }

    @Override
    public void setContents(@Nullable Item @NotNull [] items) throws IllegalArgumentException {
        if (items.length != this.getSize()) {
            throw new IllegalArgumentException("Wrong size of items array. Must be " + this.getSize());
        }
        ItemStack[] array = new ItemStack[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            array[i] = items[i] != null ? items[i].as(ItemStack.class) : null;
        }
        ((Inventory)this.wrappedObject).setContents(array);
    }

    @Override
    public void setStorageContents(@Nullable Item @NotNull [] items) throws IllegalArgumentException {
        if (items.length > this.getSize()) {
            throw new IllegalArgumentException("Wrong size of items array. Must be " + this.getSize());
        }
        ItemStack[] array = new ItemStack[items.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = items[i] != null ? items[i].as(ItemStack.class) : null;
        }
        ((Inventory)this.wrappedObject).setStorageContents(array);
    }

    @Override
    public boolean contains(ItemTypeHolder materialHolder) {
        return ((Inventory)this.wrappedObject).contains(materialHolder.as(Material.class));
    }

    @Override
    public boolean contains(Item item) {
        return ((Inventory)this.wrappedObject).contains(item.as(ItemStack.class));
    }

    @Override
    public boolean containsAtLeast(Item item, int amount) {
        return ((Inventory)this.wrappedObject).containsAtLeast(item.as(ItemStack.class), amount);
    }

    @Override
    public int getSize() {
        return ((Inventory)this.wrappedObject).getSize();
    }

    @Override
    public boolean isEmpty() {
        return ((Inventory)this.wrappedObject).isEmpty();
    }

    @Override
    public InventoryTypeHolder getType() {
        return InventoryTypeHolder.of(((Inventory)this.wrappedObject).getType());
    }

    @Override
    public void clear() {
        ((Inventory)this.wrappedObject).clear();
    }

    @Override
    public int firstEmptySlot() {
        return ((Inventory)this.wrappedObject).firstEmpty();
    }

    @Override
    public void openInventory(PlayerWrapper wrapper) {
        wrapper.asOptional(Player.class).ifPresent(player -> player.openInventory((Inventory)this.wrappedObject));
    }
}

