/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.entity;

import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityProjectile;
import io.github.pronze.lib.screaminglib.entity.EntityFirework;
import io.github.pronze.lib.screaminglib.firework.FireworkEffectHolder;
import io.github.pronze.lib.screaminglib.utils.Pair;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.FireworkEffect;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.meta.FireworkMeta;

public class BukkitEntityFirework
extends BukkitEntityProjectile
implements EntityFirework {
    public BukkitEntityFirework(Firework wrappedObject) {
        super((Projectile)wrappedObject);
    }

    @Override
    public void setEffect(List<FireworkEffectHolder> fireworkEffect, int power) {
        FireworkMeta meta = ((Firework)this.wrappedObject).getFireworkMeta();
        meta.setPower(power);
        meta.addEffects((Iterable)fireworkEffect.stream().map(p -> p.as(FireworkEffect.class)).collect(Collectors.toList()));
        ((Firework)this.wrappedObject).setFireworkMeta(meta);
    }

    @Override
    public Pair<List<FireworkEffectHolder>, Integer> getEffect() {
        FireworkMeta meta = ((Firework)this.wrappedObject).getFireworkMeta();
        return Pair.of(meta.getEffects().stream().map(FireworkEffectHolder::of).collect(Collectors.toList()), meta.getPower());
    }

    @Override
    public void detonate() {
        ((Firework)this.wrappedObject).detonate();
    }

    @Override
    public boolean isShotAtAngle() {
        return ((Firework)this.wrappedObject).isShotAtAngle();
    }

    @Override
    public void setShotAtAngle(boolean shotAtAngle) {
        ((Firework)this.wrappedObject).setShotAtAngle(shotAtAngle);
    }
}

