/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event;

import io.github.pronze.lib.screaminglib.bukkit.event.NoAutoCancellable;
import io.github.pronze.lib.screaminglib.event.EventManager;
import io.github.pronze.lib.screaminglib.event.EventPriority;
import io.github.pronze.lib.screaminglib.event.HandlerRegisteredEvent;
import io.github.pronze.lib.screaminglib.event.SEvent;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public abstract class AbstractBukkitEventHandlerFactory<T extends Event, SE extends SEvent>
implements Listener {
    protected final Map<EventPriority, EventExecutor> eventMap = new HashMap<EventPriority, EventExecutor>();
    protected final boolean fireAsync;
    protected final boolean checkOnlySameNotChildren;
    protected final Class<SE> eventClass;
    protected final Class<T> platformEventClass;

    public AbstractBukkitEventHandlerFactory(Class<T> platformEventClass, Class<SE> eventClass, Plugin plugin) {
        this(platformEventClass, eventClass, plugin, false);
    }

    public AbstractBukkitEventHandlerFactory(Class<T> platformEventClass, Class<SE> eventClass, Plugin plugin, boolean fireAsync) {
        this(platformEventClass, eventClass, plugin, fireAsync, false);
    }

    public AbstractBukkitEventHandlerFactory(Class<T> platformEventClass, Class<SE> eventClass, Plugin plugin, boolean fireAsync, boolean checkOnlySameNotChildren) {
        this.eventClass = eventClass;
        this.platformEventClass = platformEventClass;
        this.fireAsync = fireAsync;
        this.checkOnlySameNotChildren = checkOnlySameNotChildren;
        EventManager.getDefaultEventManager().register(HandlerRegisteredEvent.class, handlerRegisteredEvent -> {
            if (handlerRegisteredEvent.getEventManager() != EventManager.getDefaultEventManager()) {
                return;
            }
            if (!this.eventClass.isAssignableFrom(handlerRegisteredEvent.getEventClass())) {
                return;
            }
            EventPriority priority = handlerRegisteredEvent.getHandler().getEventPriority();
            if (!this.eventMap.containsKey((Object)priority)) {
                EventExecutor handler = (listener, event) -> {
                    if (checkOnlySameNotChildren ? !platformEventClass.equals(event.getClass()) : !platformEventClass.isInstance(event)) {
                        return;
                    }
                    SE wrapped = this.wrapEvent(event, priority);
                    if (wrapped == null) {
                        return;
                    }
                    if (!(event instanceof NoAutoCancellable) && wrapped instanceof io.github.pronze.lib.screaminglib.event.Cancellable && event instanceof Cancellable) {
                        ((io.github.pronze.lib.screaminglib.event.Cancellable)wrapped).cancelled(((Cancellable)event).isCancelled());
                    }
                    if (this.fireAsync) {
                        try {
                            EventManager.getDefaultEventManager().fireEventAsync(wrapped, priority).get();
                        }
                        catch (Throwable throwable) {
                            throw new EventException(throwable);
                        }
                    }
                    try {
                        EventManager.getDefaultEventManager().fireEvent(wrapped, priority);
                    }
                    catch (Throwable throwable) {
                        throw new EventException(throwable);
                    }
                    if (!(event instanceof NoAutoCancellable) && wrapped instanceof io.github.pronze.lib.screaminglib.event.Cancellable && event instanceof Cancellable) {
                        boolean isCancelled = ((io.github.pronze.lib.screaminglib.event.Cancellable)wrapped).cancelled();
                        ((Cancellable)event).setCancelled(isCancelled);
                    }
                };
                this.eventMap.put(handlerRegisteredEvent.getHandler().getEventPriority(), handler);
                Bukkit.getPluginManager().registerEvent(this.platformEventClass, (Listener)this, org.bukkit.event.EventPriority.valueOf((String)priority.name()), handler, plugin);
            }
        });
    }

    protected abstract SE wrapEvent(T var1, EventPriority var2);
}

