/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.block;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItem;
import io.github.pronze.lib.screaminglib.entity.EntityLiving;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.event.block.SBlockDispenseEvent;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class SBukkitBlockDispenseEvent
implements SBlockDispenseEvent,
BukkitCancellable {
    private final BlockDispenseEvent event;
    private BlockHolder block;
    private EntityLiving receiver;
    private boolean receiverCached;

    @Override
    public BlockHolder block() {
        if (this.block == null) {
            this.block = BlockMapper.wrapBlock(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    public Item item() {
        return new BukkitItem(this.event.getItem());
    }

    @Override
    public void item(Item item) {
        this.event.setItem(item.as(ItemStack.class));
    }

    @Override
    public Vector3D velocity() {
        return new Vector3D(this.event.getVelocity().getX(), this.event.getVelocity().getY(), this.event.getVelocity().getZ());
    }

    @Override
    public void velocity(Vector3D velocity) {
        this.event.setVelocity(new Vector(velocity.getX(), velocity.getY(), velocity.getZ()));
    }

    @Override
    @Nullable
    public EntityLiving receiver() {
        if (!this.receiverCached) {
            if (this.event instanceof BlockDispenseArmorEvent) {
                this.receiver = (EntityLiving)EntityMapper.wrapEntity(((BlockDispenseArmorEvent)this.event).getTargetEntity()).orElseThrow();
            }
            this.receiverCached = true;
        }
        return this.receiver;
    }

    public SBukkitBlockDispenseEvent(BlockDispenseEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitBlockDispenseEvent)) {
            return false;
        }
        SBukkitBlockDispenseEvent other = (SBukkitBlockDispenseEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockDispenseEvent this$event = this.event();
        BlockDispenseEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitBlockDispenseEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockDispenseEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitBlockDispenseEvent(event=" + this.event() + ")";
    }

    public BlockDispenseEvent event() {
        return this.event;
    }
}

