/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.block;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.block.state.BlockStateHolder;
import io.github.pronze.lib.screaminglib.block.state.BlockStateMapper;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.event.block.SBlockFertilizeEvent;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.CollectionLinkedToCollection;
import java.util.Collection;
import org.bukkit.block.BlockState;
import org.bukkit.event.block.BlockFertilizeEvent;

public class SBukkitBlockFertilizeEvent
implements SBlockFertilizeEvent,
BukkitCancellable {
    private final BlockFertilizeEvent event;
    private PlayerWrapper player;
    private boolean playerConverted;
    private BlockHolder block;
    private Collection<BlockStateHolder> changedBlockStates;

    @Override
    public PlayerWrapper player() {
        if (!this.playerConverted) {
            if (this.event.getPlayer() != null) {
                this.player = new BukkitEntityPlayer(this.event.getPlayer());
            }
            this.playerConverted = true;
        }
        return this.player;
    }

    @Override
    public BlockHolder block() {
        if (this.block == null) {
            this.block = BlockMapper.wrapBlock(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    public Collection<BlockStateHolder> changedBlockStates() {
        if (this.changedBlockStates == null) {
            this.changedBlockStates = new CollectionLinkedToCollection<BlockStateHolder, BlockState>(this.event.getBlocks(), o -> o.as(BlockState.class), o -> (BlockStateHolder)BlockStateMapper.wrapBlockState(o).orElseThrow());
        }
        return this.changedBlockStates;
    }

    public SBukkitBlockFertilizeEvent(BlockFertilizeEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitBlockFertilizeEvent)) {
            return false;
        }
        SBukkitBlockFertilizeEvent other = (SBukkitBlockFertilizeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockFertilizeEvent this$event = this.event();
        BlockFertilizeEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitBlockFertilizeEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockFertilizeEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitBlockFertilizeEvent(event=" + this.event() + ")";
    }

    public BlockFertilizeEvent event() {
        return this.event;
    }
}

