/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.entity;

import io.github.pronze.lib.screaminglib.bukkit.event.NoAutoCancellable;
import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItem;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.event.entity.SEntityDeathEvent;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.utils.CollectionLinkedToCollection;
import java.util.Collection;
import org.bukkit.event.Cancellable;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class SBukkitEntityDeathEvent
implements SEntityDeathEvent,
NoAutoCancellable {
    private final EntityDeathEvent event;
    private EntityBasic entity;
    private Collection<Item> drops;

    @Override
    public Collection<Item> drops() {
        if (this.drops == null) {
            this.drops = new CollectionLinkedToCollection<Item, ItemStack>(this.event.getDrops(), item -> item.as(ItemStack.class), BukkitItem::new);
        }
        return this.drops;
    }

    @Override
    public EntityBasic entity() {
        if (this.entity == null) {
            this.entity = (EntityBasic)EntityMapper.wrapEntity(this.event.getEntity()).orElseThrow();
        }
        return this.entity;
    }

    @Override
    public int dropExp() {
        return this.event.getDroppedExp();
    }

    @Override
    public void dropExp(int dropExp) {
        this.event.setDroppedExp(dropExp);
    }

    @Override
    public boolean cancelled() {
        if (this.event instanceof Cancellable) {
            return this.event.isCancelled();
        }
        return false;
    }

    @Override
    public void cancelled(boolean cancel) {
        if (this.event instanceof Cancellable) {
            this.event.setCancelled(cancel);
        }
    }

    public SBukkitEntityDeathEvent(EntityDeathEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitEntityDeathEvent)) {
            return false;
        }
        SBukkitEntityDeathEvent other = (SBukkitEntityDeathEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityDeathEvent this$event = this.event();
        EntityDeathEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitEntityDeathEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityDeathEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitEntityDeathEvent(event=" + this.event() + ")";
    }

    public EntityDeathEvent event() {
        return this.event;
    }
}

