/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.entity;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.event.entity.SEntityExplodeEvent;
import io.github.pronze.lib.screaminglib.utils.CollectionLinkedToCollection;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import java.util.Collection;
import org.bukkit.block.Block;
import org.bukkit.event.entity.EntityExplodeEvent;

public class SBukkitEntityExplodeEvent
implements SEntityExplodeEvent,
BukkitCancellable {
    private final EntityExplodeEvent event;
    private EntityBasic entity;
    private LocationHolder location;
    private Collection<BlockHolder> blocks;

    @Override
    public EntityBasic entity() {
        if (this.entity == null) {
            this.entity = (EntityBasic)EntityMapper.wrapEntity(this.event.getEntity()).orElseThrow();
        }
        return this.entity;
    }

    @Override
    public LocationHolder location() {
        if (this.location == null) {
            this.location = LocationMapper.wrapLocation(this.event.getLocation());
        }
        return this.location;
    }

    @Override
    public Collection<BlockHolder> blocks() {
        if (this.blocks == null) {
            this.blocks = new CollectionLinkedToCollection<BlockHolder, Block>(this.event.blockList(), o -> o.as(Block.class), BlockMapper::wrapBlock);
        }
        return this.blocks;
    }

    @Override
    public float yield() {
        return this.event.getYield();
    }

    @Override
    public void yield(float yield) {
        this.event.setYield(yield);
    }

    public SBukkitEntityExplodeEvent(EntityExplodeEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitEntityExplodeEvent)) {
            return false;
        }
        SBukkitEntityExplodeEvent other = (SBukkitEntityExplodeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityExplodeEvent this$event = this.event();
        EntityExplodeEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitEntityExplodeEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityExplodeEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitEntityExplodeEvent(event=" + this.event() + ")";
    }

    public EntityExplodeEvent event() {
        return this.event;
    }
}

