/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.entity;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.event.entity.SEntityPlaceEvent;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.BlockFace;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.jetbrains.annotations.Nullable;

public class SBukkitEntityPlaceEvent
implements SEntityPlaceEvent,
BukkitCancellable {
    private final EntityPlaceEvent event;
    private EntityBasic entity;
    private PlayerWrapper player;
    private boolean playerCached;
    private BlockHolder block;
    private BlockFace blockFace;

    @Override
    public EntityBasic entity() {
        if (this.entity == null) {
            this.entity = (EntityBasic)EntityMapper.wrapEntity(this.event.getEntity()).orElseThrow();
        }
        return this.entity;
    }

    @Override
    @Nullable
    public PlayerWrapper player() {
        if (!this.playerCached) {
            if (this.event.getPlayer() != null) {
                this.player = new BukkitEntityPlayer(this.event.getPlayer());
            }
            this.playerCached = true;
        }
        return this.player;
    }

    @Override
    public BlockHolder block() {
        if (this.block == null) {
            this.block = BlockMapper.wrapBlock(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    public BlockFace blockFace() {
        if (this.blockFace == null) {
            this.blockFace = BlockFace.valueOf(this.event.getBlockFace().name());
        }
        return this.blockFace;
    }

    public SBukkitEntityPlaceEvent(EntityPlaceEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitEntityPlaceEvent)) {
            return false;
        }
        SBukkitEntityPlaceEvent other = (SBukkitEntityPlaceEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityPlaceEvent this$event = this.event();
        EntityPlaceEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitEntityPlaceEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityPlaceEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitEntityPlaceEvent(event=" + this.event() + ")";
    }

    public EntityPlaceEvent event() {
        return this.event;
    }
}

