/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.player;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItem;
import io.github.pronze.lib.screaminglib.event.player.SPlayerBucketEvent;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.BlockFace;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SBukkitPlayerBucketEvent
implements SPlayerBucketEvent,
BukkitCancellable {
    private final PlayerBucketEvent event;
    private PlayerWrapper player;
    private BlockHolder block;
    private BlockHolder blockClicked;
    private BlockFace blockFace;
    private ItemTypeHolder bucket;

    @Override
    public PlayerWrapper player() {
        if (this.player == null) {
            this.player = new BukkitEntityPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    public BlockHolder block() {
        if (this.block == null) {
            this.block = BlockMapper.wrapBlock(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    public BlockHolder blockClicked() {
        if (this.blockClicked == null) {
            this.blockClicked = BlockMapper.wrapBlock(this.event.getBlockClicked());
        }
        return this.blockClicked;
    }

    @Override
    public BlockFace blockFace() {
        if (this.blockFace == null) {
            this.blockFace = BlockFace.valueOf(this.event.getBlockFace().name());
        }
        return this.blockFace;
    }

    @Override
    public ItemTypeHolder bucket() {
        if (this.bucket == null) {
            this.bucket = ItemTypeHolder.of(this.event.getBucket());
        }
        return this.bucket;
    }

    @Override
    @Nullable
    public Item item() {
        return this.event.getItemStack() != null ? new BukkitItem(this.event.getItemStack()) : null;
    }

    @Override
    public void item(@Nullable Item item) {
        this.event.setItemStack(item == null ? null : item.as(ItemStack.class));
    }

    @Override
    public SPlayerBucketEvent.Action action() {
        return this.event instanceof PlayerBucketFillEvent ? SPlayerBucketEvent.Action.FILL : SPlayerBucketEvent.Action.EMPTY;
    }

    public SBukkitPlayerBucketEvent(PlayerBucketEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitPlayerBucketEvent)) {
            return false;
        }
        SBukkitPlayerBucketEvent other = (SBukkitPlayerBucketEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerBucketEvent this$event = this.event();
        PlayerBucketEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitPlayerBucketEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerBucketEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitPlayerBucketEvent(event=" + this.event() + ")";
    }

    public PlayerBucketEvent event() {
        return this.event;
    }
}

