/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.player;

import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.event.player.SPlayerFishEvent;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import org.bukkit.event.player.PlayerFishEvent;
import org.jetbrains.annotations.Nullable;

public class SBukkitPlayerFishEvent
implements SPlayerFishEvent,
BukkitCancellable {
    private final PlayerFishEvent event;
    private PlayerWrapper player;
    private EntityBasic entity;
    private boolean entityCached;
    private SPlayerFishEvent.State state;
    private EntityBasic hookEntity;

    @Override
    public PlayerWrapper player() {
        if (this.player == null) {
            this.player = new BukkitEntityPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @Nullable
    public EntityBasic caughtEntity() {
        if (!this.entityCached) {
            if (this.event.getCaught() != null) {
                this.entity = (EntityBasic)EntityMapper.wrapEntity(this.event.getCaught()).orElseThrow();
            }
            this.entityCached = true;
        }
        return this.entity;
    }

    @Override
    public int exp() {
        return this.event.getExpToDrop();
    }

    @Override
    public void exp(int exp) {
        this.event.setExpToDrop(exp);
    }

    @Override
    public SPlayerFishEvent.State state() {
        if (this.state == null) {
            this.state = SPlayerFishEvent.State.convert(this.event.getState().name());
        }
        return this.state;
    }

    @Override
    public EntityBasic hookEntity() {
        if (this.hookEntity == null) {
            this.hookEntity = (EntityBasic)EntityMapper.wrapEntity(this.event.getHook()).orElseThrow();
        }
        return this.hookEntity;
    }

    public SBukkitPlayerFishEvent(PlayerFishEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitPlayerFishEvent)) {
            return false;
        }
        SBukkitPlayerFishEvent other = (SBukkitPlayerFishEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerFishEvent this$event = this.event();
        PlayerFishEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitPlayerFishEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerFishEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitPlayerFishEvent(event=" + this.event() + ")";
    }

    public PlayerFishEvent event() {
        return this.event;
    }
}

