/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.player;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItem;
import io.github.pronze.lib.screaminglib.event.player.SPlayerHarvestBlockEvent;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.CollectionLinkedToCollection;
import java.util.Collection;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.inventory.ItemStack;

public class SBukkitPlayerHarvestBlockEvent
implements SPlayerHarvestBlockEvent,
BukkitCancellable {
    private final PlayerHarvestBlockEvent event;
    private PlayerWrapper player;
    private Collection<Item> itemsHarvested;
    private BlockHolder harvestedBlock;

    @Override
    public PlayerWrapper player() {
        if (this.player == null) {
            this.player = new BukkitEntityPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    public Collection<Item> itemsHarvested() {
        if (this.itemsHarvested == null) {
            this.itemsHarvested = new CollectionLinkedToCollection<Item, ItemStack>(this.event.getItemsHarvested(), item -> item.as(ItemStack.class), BukkitItem::new);
        }
        return this.itemsHarvested;
    }

    @Override
    public BlockHolder harvestedBlock() {
        if (this.harvestedBlock == null) {
            this.harvestedBlock = BlockMapper.wrapBlock(this.event.getHarvestedBlock());
        }
        return this.harvestedBlock;
    }

    public SBukkitPlayerHarvestBlockEvent(PlayerHarvestBlockEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitPlayerHarvestBlockEvent)) {
            return false;
        }
        SBukkitPlayerHarvestBlockEvent other = (SBukkitPlayerHarvestBlockEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerHarvestBlockEvent this$event = this.event();
        PlayerHarvestBlockEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitPlayerHarvestBlockEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerHarvestBlockEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitPlayerHarvestBlockEvent(event=" + this.event() + ")";
    }

    public PlayerHarvestBlockEvent event() {
        return this.event;
    }
}

