/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.player;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.NoAutoCancellable;
import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItemView;
import io.github.pronze.lib.screaminglib.event.SEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerInteractEvent;
import io.github.pronze.lib.screaminglib.item.ItemView;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotHolder;
import io.github.pronze.lib.screaminglib.utils.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class SBukkitPlayerInteractEvent
implements SPlayerInteractEvent,
NoAutoCancellable {
    private final PlayerInteractEvent event;
    private PlayerWrapper player;
    private ItemView item;
    private boolean itemCached;
    private SPlayerInteractEvent.Action action;
    private BlockFace blockFace;
    private BlockHolder clickedBlock;
    private boolean clickedBlockCached;
    private EquipmentSlotHolder hand;
    private boolean handCached;

    @Override
    public PlayerWrapper player() {
        if (this.player == null) {
            this.player = new BukkitEntityPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @Nullable
    public ItemView item() {
        if (!this.itemCached) {
            if (this.event.getItem() != null) {
                this.item = new BukkitItemView(this.event.getItem());
            }
            this.itemCached = true;
        }
        return this.item;
    }

    @Override
    public SPlayerInteractEvent.Action action() {
        if (this.action == null) {
            this.action = SPlayerInteractEvent.Action.convert(this.event.getAction().name());
        }
        return this.action;
    }

    @Override
    @Nullable
    public BlockHolder clickedBlock() {
        if (!this.clickedBlockCached) {
            if (this.event.getClickedBlock() != null) {
                this.clickedBlock = BlockMapper.wrapBlock(this.event.getClickedBlock());
            }
            this.clickedBlockCached = true;
        }
        return this.clickedBlock;
    }

    @Override
    public BlockFace blockFace() {
        if (this.blockFace == null) {
            this.blockFace = BlockFace.valueOf(this.event.getBlockFace().name());
        }
        return this.blockFace;
    }

    @Override
    public SEvent.Result useClickedBlock() {
        return SEvent.Result.convert(this.event.useInteractedBlock().name());
    }

    @Override
    public void useClickedBlock(SEvent.Result useClickedBlock) {
        this.event.setUseInteractedBlock(Event.Result.valueOf((String)useClickedBlock.name()));
    }

    @Override
    public SEvent.Result useItemInHand() {
        return SEvent.Result.convert(this.event.useItemInHand().name());
    }

    @Override
    public void useItemInHand(SEvent.Result useItemInHand) {
        this.event.setUseItemInHand(Event.Result.valueOf((String)useItemInHand.name()));
    }

    @Override
    @Nullable
    public EquipmentSlotHolder hand() {
        if (!this.handCached) {
            if (this.event.getHand() != null) {
                this.hand = EquipmentSlotHolder.of(this.event.getHand());
            }
            this.handCached = true;
        }
        return this.hand;
    }

    public SBukkitPlayerInteractEvent(PlayerInteractEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitPlayerInteractEvent)) {
            return false;
        }
        SBukkitPlayerInteractEvent other = (SBukkitPlayerInteractEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerInteractEvent this$event = this.event();
        PlayerInteractEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitPlayerInteractEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerInteractEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitPlayerInteractEvent(event=" + this.event() + ")";
    }

    public PlayerInteractEvent event() {
        return this.event;
    }
}

