/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.player;

import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItem;
import io.github.pronze.lib.screaminglib.container.Container;
import io.github.pronze.lib.screaminglib.container.ContainerFactory;
import io.github.pronze.lib.screaminglib.event.SEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerInventoryClickEvent;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.ClickType;
import io.github.pronze.lib.screaminglib.utils.InventoryAction;
import io.github.pronze.lib.screaminglib.utils.SlotType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SBukkitPlayerInventoryClickEvent
implements SPlayerInventoryClickEvent,
BukkitCancellable {
    private final InventoryClickEvent event;
    private PlayerWrapper player;
    private Container clickedInventory;
    private boolean clickedInventoryCached;
    private ClickType clickType;
    private Container inventory;
    private InventoryAction action;
    private SlotType slotType;

    @Override
    public PlayerWrapper player() {
        if (this.player == null) {
            this.player = new BukkitEntityPlayer((Player)this.event.getWhoClicked());
        }
        return this.player;
    }

    @Override
    @Nullable
    public Item cursorItem() {
        if (this.event.getCursor() == null) {
            return null;
        }
        return new BukkitItem(this.event.getCursor());
    }

    @Override
    @Nullable
    public Item currentItem() {
        if (this.event.getCurrentItem() == null) {
            return null;
        }
        return new BukkitItem(this.event.getCurrentItem());
    }

    @Override
    public void currentItem(Item currentItem) {
        this.event.setCurrentItem(currentItem == null ? null : currentItem.as(ItemStack.class));
    }

    @Override
    @Nullable
    public Container clickedInventory() {
        if (!this.clickedInventoryCached) {
            if (this.event.getClickedInventory() != null) {
                this.clickedInventory = (Container)ContainerFactory.wrapContainer(this.event.getClickedInventory()).orElseThrow();
            }
            this.clickedInventoryCached = true;
        }
        return this.clickedInventory;
    }

    @Override
    public ClickType getClickType() {
        if (this.clickType == null) {
            this.clickType = ClickType.convert(this.event.getClick().name());
        }
        return this.clickType;
    }

    @Override
    public Container inventory() {
        if (this.inventory == null) {
            this.inventory = (Container)ContainerFactory.wrapContainer(this.event.getInventory()).orElseThrow();
        }
        return this.inventory;
    }

    @Override
    public InventoryAction action() {
        if (this.action == null) {
            this.action = InventoryAction.convert(this.event.getAction().name());
        }
        return this.action;
    }

    @Override
    public int hotbarButton() {
        return this.event.getHotbarButton();
    }

    @Override
    public int slot() {
        return this.event.getSlot();
    }

    @Override
    public SlotType slotType() {
        if (this.slotType == null) {
            this.slotType = SlotType.convert(this.event.getSlotType().name());
        }
        return this.slotType;
    }

    @Override
    public int rawSlot() {
        return this.event.getRawSlot();
    }

    @Override
    public SEvent.Result result() {
        return SEvent.Result.convert(this.event.getResult().name());
    }

    @Override
    public void result(SEvent.Result result) {
        this.event.setResult(Event.Result.valueOf((String)this.event.getResult().name()));
    }

    public SBukkitPlayerInventoryClickEvent(InventoryClickEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitPlayerInventoryClickEvent)) {
            return false;
        }
        SBukkitPlayerInventoryClickEvent other = (SBukkitPlayerInventoryClickEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InventoryClickEvent this$event = this.event();
        InventoryClickEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitPlayerInventoryClickEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InventoryClickEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitPlayerInventoryClickEvent(event=" + this.event() + ")";
    }

    public InventoryClickEvent event() {
        return this.event;
    }
}

