/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.world;

import io.github.pronze.lib.screaminglib.block.state.BlockStateHolder;
import io.github.pronze.lib.screaminglib.block.state.BlockStateMapper;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.event.world.SPlantGrowEvent;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.CollectionLinkedToCollection;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import java.util.Collection;
import org.bukkit.block.BlockState;
import org.bukkit.event.world.StructureGrowEvent;
import org.jetbrains.annotations.Nullable;

public class SBukkitPlantGrowEvent
implements SPlantGrowEvent,
BukkitCancellable {
    private final StructureGrowEvent event;
    private Collection<BlockStateHolder> collection;
    private LocationHolder location;
    private PlayerWrapper player;
    private boolean playerCached;

    @Override
    public Collection<BlockStateHolder> blockStates() {
        if (this.collection == null) {
            this.collection = new CollectionLinkedToCollection<BlockStateHolder, BlockState>(this.event.getBlocks(), o -> o.as(BlockState.class), o -> (BlockStateHolder)BlockStateMapper.wrapBlockState(o).orElseThrow());
        }
        return this.collection;
    }

    @Override
    public LocationHolder getLocation() {
        if (this.location == null) {
            this.location = LocationMapper.wrapLocation(this.event.getLocation());
        }
        return this.location;
    }

    @Override
    @Nullable
    public PlayerWrapper player() {
        if (!this.playerCached) {
            if (this.event.getPlayer() != null) {
                this.player = new BukkitEntityPlayer(this.event.getPlayer());
            }
            this.playerCached = true;
        }
        return this.player;
    }

    @Override
    public boolean boneMealed() {
        return this.event.isFromBonemeal();
    }

    public SBukkitPlantGrowEvent(StructureGrowEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitPlantGrowEvent)) {
            return false;
        }
        SBukkitPlantGrowEvent other = (SBukkitPlantGrowEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StructureGrowEvent this$event = this.event();
        StructureGrowEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitPlantGrowEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StructureGrowEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitPlantGrowEvent(event=" + this.event() + ")";
    }

    public StructureGrowEvent event() {
        return this.event;
    }
}

