/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.firework;

import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.kyori.adventure.util.RGBLike;
import io.github.pronze.lib.screaminglib.firework.FireworkEffectHolder;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;

public class BukkitFireworkEffectHolder
extends BasicWrapper<FireworkEffect>
implements FireworkEffectHolder {
    public BukkitFireworkEffectHolder(FireworkEffect.Type type) {
        this(FireworkEffect.builder().with(type).withColor(Color.WHITE).build());
    }

    public BukkitFireworkEffectHolder(FireworkEffect wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public String platformName() {
        return ((FireworkEffect)this.wrappedObject).getType().name();
    }

    @Override
    public List<RGBLike> colors() {
        return ((FireworkEffect)this.wrappedObject).getColors().stream().map(color -> TextColor.color(color.getRed(), color.getGreen(), color.getBlue())).collect(Collectors.toList());
    }

    @Override
    public List<RGBLike> fadeColors() {
        return ((FireworkEffect)this.wrappedObject).getFadeColors().stream().map(color -> TextColor.color(color.getRed(), color.getGreen(), color.getBlue())).collect(Collectors.toList());
    }

    @Override
    public boolean flicker() {
        return ((FireworkEffect)this.wrappedObject).hasFlicker();
    }

    @Override
    public boolean trail() {
        return ((FireworkEffect)this.wrappedObject).hasTrail();
    }

    @Override
    public FireworkEffectHolder withColors(List<RGBLike> colors) {
        return new BukkitFireworkEffectHolder(FireworkEffect.builder().with(((FireworkEffect)this.wrappedObject).getType()).withColor((Iterable)colors.stream().map(rgbLike -> Color.fromRGB((int)rgbLike.red(), (int)rgbLike.green(), (int)rgbLike.blue())).collect(Collectors.toList())).withFade((Iterable)((FireworkEffect)this.wrappedObject).getFadeColors()).flicker(((FireworkEffect)this.wrappedObject).hasFlicker()).trail(((FireworkEffect)this.wrappedObject).hasTrail()).build());
    }

    @Override
    public FireworkEffectHolder withFadeColors(List<RGBLike> fadeColors) {
        return new BukkitFireworkEffectHolder(FireworkEffect.builder().with(((FireworkEffect)this.wrappedObject).getType()).withColor((Iterable)((FireworkEffect)this.wrappedObject).getColors()).withFade((Iterable)fadeColors.stream().map(rgbLike -> Color.fromRGB((int)rgbLike.red(), (int)rgbLike.green(), (int)rgbLike.blue())).collect(Collectors.toList())).flicker(((FireworkEffect)this.wrappedObject).hasFlicker()).trail(((FireworkEffect)this.wrappedObject).hasTrail()).build());
    }

    @Override
    public FireworkEffectHolder withFlicker(boolean flicker) {
        return new BukkitFireworkEffectHolder(FireworkEffect.builder().with(((FireworkEffect)this.wrappedObject).getType()).withColor((Iterable)((FireworkEffect)this.wrappedObject).getColors()).withFade((Iterable)((FireworkEffect)this.wrappedObject).getFadeColors()).flicker(flicker).trail(((FireworkEffect)this.wrappedObject).hasTrail()).build());
    }

    @Override
    public FireworkEffectHolder withTrail(boolean trail) {
        return new BukkitFireworkEffectHolder(FireworkEffect.builder().with(((FireworkEffect)this.wrappedObject).getType()).withColor((Iterable)((FireworkEffect)this.wrappedObject).getColors()).withFade((Iterable)((FireworkEffect)this.wrappedObject).getFadeColors()).flicker(((FireworkEffect)this.wrappedObject).hasFlicker()).trail(trail).build());
    }

    @Override
    public boolean is(Object object) {
        if (object instanceof FireworkEffect.Type) {
            return ((FireworkEffect)this.wrappedObject).getType().equals(object);
        }
        if (object instanceof FireworkEffect || object instanceof FireworkEffectHolder) {
            return this.equals(object);
        }
        return this.equals(FireworkEffectHolder.ofOptional(object).orElse(null));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    public <T> T as(Class<T> type) {
        if (type == FireworkEffect.Type.class) {
            return (T)((FireworkEffect)this.wrappedObject).getType();
        }
        return super.as(type);
    }
}

