/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.item;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.attribute.AttributeMapping;
import io.github.pronze.lib.screaminglib.attribute.ItemAttributeHolder;
import io.github.pronze.lib.screaminglib.bukkit.BukkitCore;
import io.github.pronze.lib.screaminglib.bukkit.attribute.BukkitItemAttribute;
import io.github.pronze.lib.screaminglib.bukkit.item.ItemMetaHelper;
import io.github.pronze.lib.screaminglib.bukkit.item.builder.BukkitItemBuilder;
import io.github.pronze.lib.screaminglib.bukkit.item.data.BukkitItemDataCustomTags;
import io.github.pronze.lib.screaminglib.bukkit.item.data.BukkitItemDataPersistentContainer;
import io.github.pronze.lib.screaminglib.bukkit.item.data.CraftBukkitItemData;
import io.github.pronze.lib.screaminglib.item.HideFlags;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.item.builder.ItemBuilder;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import io.github.pronze.lib.screaminglib.item.data.ItemData;
import io.github.pronze.lib.screaminglib.item.meta.EnchantmentHolder;
import io.github.pronze.lib.screaminglib.metadata.MetadataCollectionKey;
import io.github.pronze.lib.screaminglib.metadata.MetadataKey;
import io.github.pronze.lib.screaminglib.nms.accessors.CompoundTagAccessor;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import io.github.pronze.lib.screaminglib.utils.adventure.AdventureUtils;
import io.github.pronze.lib.screaminglib.utils.adventure.ComponentObjectLink;
import io.github.pronze.lib.screaminglib.utils.adventure.ComponentUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.jetbrains.annotations.Nullable;

public class BukkitItem
extends BasicWrapper<ItemStack>
implements Item {
    public BukkitItem(ItemStack wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public ItemTypeHolder getType() {
        return ItemTypeHolder.of(((ItemStack)this.wrappedObject).getType());
    }

    @Override
    public int getAmount() {
        return ((ItemStack)this.wrappedObject).getAmount();
    }

    @Override
    @Nullable
    public Component getDisplayName() {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            return ComponentObjectLink.processGetter(meta, "displayName", () -> ((ItemMeta)meta).getDisplayName());
        }
        return null;
    }

    @Override
    public List<Component> getLore() {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null && meta.hasLore()) {
            ArrayList list = new ArrayList();
            AdventureUtils.get(meta, "lore", new Class[0]).ifPresentOrElse(classMethod -> classMethod.invokeInstanceResulted(meta, new Object[0]).as(List.class).stream().map(ComponentUtils::componentFromPlatform).forEach(o -> list.add((Component)o)), () -> Objects.requireNonNull(meta.getLore()).stream().map(AdventureHelper::toComponent).forEach(list::add));
            return List.copyOf(list);
        }
        return List.of();
    }

    @Override
    public List<ItemAttributeHolder> getAttributeModifiers() {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null && Reflect.hasMethod(meta, "hasAttributeModifiers", new Class[0]) && meta.hasAttributeModifiers()) {
            ArrayList<ItemAttributeHolder> list = new ArrayList<ItemAttributeHolder>();
            meta.getAttributeModifiers().forEach((attribute, attributeModifier) -> AttributeMapping.wrapItemAttribute(new BukkitItemAttribute((Attribute)attribute, (AttributeModifier)attributeModifier)).ifPresent(list::add));
            return list;
        }
        return List.of();
    }

    @Override
    public List<EnchantmentHolder> getEnchantments() {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            ArrayList<EnchantmentHolder> list = new ArrayList<EnchantmentHolder>();
            if (meta instanceof EnchantmentStorageMeta) {
                ((EnchantmentStorageMeta)meta).getStoredEnchants().entrySet().forEach(entry -> EnchantmentHolder.ofOptional(entry).ifPresent(list::add));
            } else {
                meta.getEnchants().entrySet().forEach(entry -> EnchantmentHolder.ofOptional(entry).ifPresent(list::add));
            }
            return list;
        }
        return List.of();
    }

    @Override
    public ItemData getData() {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            if (Reflect.hasMethod(meta, "getPersistentDataContainer", new Class[0])) {
                return new BukkitItemDataPersistentContainer(BukkitCore.getPlugin(), meta.getPersistentDataContainer());
            }
            if (Reflect.hasMethod(meta, "getCustomTagContainer", new Class[0])) {
                return new BukkitItemDataCustomTags(BukkitCore.getPlugin(), meta.getCustomTagContainer());
            }
            Map unhandled = (Map)Reflect.getField((Object)meta, "unhandledTags");
            if (unhandled.containsKey("PublicBukkitValues")) {
                Object compound = unhandled.get("PublicBukkitValues");
                HashMap<String, Object> nmap = new HashMap<String, Object>();
                if (CompoundTagAccessor.getType().isInstance(compound)) {
                    Set keys = (Set)Reflect.fastInvoke(compound, CompoundTagAccessor.getMethodGetAllKeys1());
                    for (Object key : keys) {
                        nmap.put(key.toString(), Reflect.fastInvoke(compound, CompoundTagAccessor.getMethodGet1(), key));
                    }
                }
                return new CraftBukkitItemData(nmap);
            }
            return new CraftBukkitItemData(new HashMap<String, Object>());
        }
        return null;
    }

    @Override
    public List<HideFlags> getHideFlags() {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            return meta.getItemFlags().stream().map(Enum::name).map(HideFlags::convert).collect(Collectors.toList());
        }
        return List.of();
    }

    @Override
    public Integer getCustomModelData() {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            try {
                if (meta.hasCustomModelData()) {
                    return meta.getCustomModelData();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean isUnbreakable() {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            if (Reflect.hasMethod(meta, "isUnbreakable", new Class[0])) {
                return meta.isUnbreakable();
            }
            Object spigot = Reflect.fastInvoke((Object)meta, "spigot");
            if (spigot != null) {
                return (Boolean)Reflect.fastInvoke(spigot, "isUnbreakable");
            }
        }
        return false;
    }

    @Override
    public int getRepairCost() {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta instanceof Repairable) {
            return ((Repairable)meta).getRepairCost();
        }
        return 0;
    }

    @Override
    public ItemBuilder builder() {
        return new BukkitItemBuilder(((ItemStack)this.wrappedObject).clone());
    }

    @Override
    public boolean isSimilar(Item item) {
        return ((ItemStack)this.wrappedObject).isSimilar(item.as(ItemStack.class));
    }

    @Override
    public Item clone() {
        return new BukkitItem(((ItemStack)this.wrappedObject).clone());
    }

    @Override
    public boolean supportsMetadata(MetadataKey<?> key) {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            return ItemMetaHelper.supportsMetadata(meta, key);
        }
        return false;
    }

    @Override
    public boolean supportsMetadata(MetadataCollectionKey<?> key) {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            return ItemMetaHelper.supportsMetadata(meta, key);
        }
        return false;
    }

    @Override
    @Nullable
    public <T> T getMetadata(MetadataKey<T> key) {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            return ItemMetaHelper.getMetadata(meta, key);
        }
        return null;
    }

    @Override
    public <T> Optional<T> getMetadataOptional(MetadataKey<T> key) {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            return Optional.ofNullable(ItemMetaHelper.getMetadata(meta, key));
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public <T> Collection<T> getMetadata(MetadataCollectionKey<T> key) {
        ItemMeta meta = ((ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            return ItemMetaHelper.getMetadata(meta, key);
        }
        return null;
    }

    @Override
    public <T> T as(Class<T> type) {
        try {
            return super.as(type);
        }
        catch (Throwable ignored) {
            return ItemFactory.convertItem(this, type);
        }
    }
}

