/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.item;

import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.bukkit.block.BukkitBlockTypeHolder;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class BukkitItemTypeHolder
extends BasicWrapper<Material>
implements ItemTypeHolder {
    private short forcedDurability;

    public BukkitItemTypeHolder(Material wrappedObject) {
        super(wrappedObject);
        if (!wrappedObject.isItem()) {
            throw new UnsupportedOperationException("BukkitItemTypeHolder can wrap only item types!!!");
        }
    }

    @Override
    public String platformName() {
        return ((Material)this.wrappedObject).name();
    }

    @Override
    public short forcedDurability() {
        return this.forcedDurability;
    }

    @Override
    public int maxStackSize() {
        return ((Material)this.wrappedObject).getMaxStackSize();
    }

    @Override
    public ItemTypeHolder withForcedDurability(short durability) {
        BukkitItemTypeHolder holder = new BukkitItemTypeHolder((Material)this.wrappedObject);
        holder.forcedDurability = durability;
        return holder;
    }

    @Override
    public Optional<BlockTypeHolder> block() {
        if (!((Material)this.wrappedObject).isBlock()) {
            return Optional.empty();
        }
        return Optional.of(new BukkitBlockTypeHolder((Material)this.wrappedObject));
    }

    @Override
    public boolean is(Object object) {
        if (object instanceof Material || object instanceof ItemTypeHolder) {
            return this.equals(object);
        }
        return this.equals(ItemTypeHolder.ofOptional(object).orElse(null));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    public <T> T as(Class<T> type) {
        if (type == ItemStack.class) {
            ItemMeta meta;
            ItemStack stack = new ItemStack((Material)this.wrappedObject);
            if (this.forcedDurability != 0 && (meta = stack.getItemMeta()) instanceof Damageable) {
                ((Damageable)meta).setDamage((int)this.forcedDurability);
                stack.setItemMeta(meta);
            }
            return (T)stack;
        }
        return super.as(type);
    }
}

