/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.item;

import io.github.pronze.lib.screaminglib.bukkit.metadata.MetadataValuesRemapper;
import io.github.pronze.lib.screaminglib.metadata.MetadataCollectionKey;
import io.github.pronze.lib.screaminglib.metadata.MetadataKey;
import io.github.pronze.lib.screaminglib.utils.reflect.InstanceMethod;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class ItemMetaHelper {
    private static final Map<String, String> NBT_TO_BUKKIT_METHODS = Map.ofEntries(Map.entry("Potion", "BasePotionData"), Map.entry("CustomPotionColor", "Color"), Map.entry("CustomPotionEffects", "CustomEffects"), Map.entry("Recipes", "Recipes"), Map.entry("Fireworks.Explosions", "Effects"), Map.entry("Fireworks.Flight", "Power"), Map.entry("Explosion", "Effect"), Map.entry("display.color", "Color"), Map.entry("SkullOwner", "Owner"));

    public static boolean supportsMetadata(ItemMeta meta, MetadataKey<?> key) {
        String name = NBT_TO_BUKKIT_METHODS.getOrDefault(key.getKey(), key.getKey().replace(".", ""));
        return Reflect.getMethod((Object)meta, "get" + name, new Class[0]).isPresent();
    }

    @Nullable
    public static <T> T getMetadata(ItemMeta meta, MetadataKey<T> key) {
        String name = NBT_TO_BUKKIT_METHODS.getOrDefault(key.getKey(), key.getKey().replace(".", ""));
        InstanceMethod hasMethod = Reflect.getMethod((Object)meta, "has" + name, new Class[0]);
        InstanceMethod getMethod = Reflect.getMethod((Object)meta, "get" + name, new Class[0]);
        if (hasMethod.isPresent() && !((Boolean)hasMethod.invoke(new Object[0])).booleanValue()) {
            return null;
        }
        if (getMethod.isPresent()) {
            return (T)MetadataValuesRemapper.remapToWrapper(getMethod.invoke(new Object[0]), key.getType());
        }
        return null;
    }

    public static boolean supportsMetadata(ItemMeta meta, MetadataCollectionKey<?> key) {
        String name = NBT_TO_BUKKIT_METHODS.getOrDefault(key.getKey(), key.getKey().replace(".", ""));
        return Reflect.getMethod((Object)meta, "get" + name, new Class[0]).isPresent();
    }

    public static <T> Collection<T> getMetadata(ItemMeta meta, MetadataCollectionKey<T> key) {
        String name = NBT_TO_BUKKIT_METHODS.getOrDefault(key.getKey(), key.getKey().replace(".", ""));
        InstanceMethod hasMethod = Reflect.getMethod((Object)meta, "has" + name, new Class[0]);
        InstanceMethod getMethod = Reflect.getMethod((Object)meta, "get" + name, new Class[0]);
        if (hasMethod.isPresent() && !((Boolean)hasMethod.invoke(new Object[0])).booleanValue()) {
            return null;
        }
        if (getMethod.isPresent()) {
            return getMethod.invokeResulted(new Object[0]).as(Collection.class).stream().map(o -> MetadataValuesRemapper.remapToWrapper(o, key.getComponentType())).collect(Collectors.toList());
        }
        return null;
    }

    public static <T> void setMetadata(ItemMeta meta, MetadataKey<T> key, Object value) {
        String name = NBT_TO_BUKKIT_METHODS.getOrDefault(key.getKey(), key.getKey().replace(".", ""));
        List<InstanceMethod> setMethod = Reflect.getMethodsCalled(meta, "set" + name, 1);
        if (!setMethod.isEmpty()) {
            for (InstanceMethod m : setMethod) {
                try {
                    m.invoke(MetadataValuesRemapper.remapToPlatform(value, m.getMethod().getParameterTypes()[0]));
                    return;
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    public static <T> void setMetadata(ItemMeta meta, MetadataCollectionKey<T> key, Collection<T> value) {
        String name = NBT_TO_BUKKIT_METHODS.getOrDefault(key.getKey(), key.getKey().replace(".", ""));
        List<InstanceMethod> setMethod = Reflect.getMethodsCalled(meta, "set" + name, 1);
        if (!setMethod.isEmpty()) {
            for (InstanceMethod m : setMethod) {
                try {
                    if (!Collection.class.isAssignableFrom(m.getMethod().getParameterTypes()[0])) {
                        return;
                    }
                    m.invoke(value.stream().map(o -> MetadataValuesRemapper.remapToPlatform(o, (Class)((ParameterizedType)m.getMethod().getParameters()[0].getParameterizedType()).getActualTypeArguments()[0])).collect(Collectors.toList()));
                    return;
                }
                catch (Throwable throwable) {
                }
            }
        }
        InstanceMethod clearMethod = Reflect.getMethod((Object)meta, "clear" + name, new Class[0]);
        List<InstanceMethod> addMethod = Reflect.getMethodsCalled(meta, "add" + name.substring(0, name.length() - 1), 1);
        if (addMethod.isEmpty()) {
            addMethod = Reflect.getMethodsCalled(meta, "add" + name.substring(0, name.length() - 1), 2);
        }
        if (clearMethod.isPresent() && !addMethod.isEmpty()) {
            clearMethod.invoke(new Object[0]);
            for (InstanceMethod m : addMethod) {
                try {
                    if (!Collection.class.isAssignableFrom(m.getMethod().getParameterTypes()[0])) {
                        return;
                    }
                    m.invoke(value.stream().map(o -> MetadataValuesRemapper.remapToPlatform(o, (Class)((ParameterizedType)m.getMethod().getParameters()[0].getParameterizedType()).getActualTypeArguments()[0])).collect(Collectors.toList()));
                    return;
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    public static <T> void addMetadata(ItemMeta meta, MetadataCollectionKey<T> key, T value) {
        List<InstanceMethod> addMethod;
        List<InstanceMethod> setMethod;
        String name = NBT_TO_BUKKIT_METHODS.getOrDefault(key.getKey(), key.getKey().replace(".", ""));
        InstanceMethod hasMethod = Reflect.getMethod((Object)meta, "has" + name, new Class[0]);
        InstanceMethod getMethod = Reflect.getMethod((Object)meta, "get" + name, new Class[0]);
        List orig = List.of();
        if (hasMethod.isPresent() && ((Boolean)hasMethod.invoke(new Object[0])).booleanValue()) {
            orig = getMethod.invokeResulted(new Object[0]).as(List.class);
        }
        if (!(setMethod = Reflect.getMethodsCalled(meta, "set" + name, 1)).isEmpty()) {
            for (InstanceMethod m : setMethod) {
                try {
                    if (!Collection.class.isAssignableFrom(m.getMethod().getParameterTypes()[0])) {
                        return;
                    }
                    ArrayList<Object> orig2 = new ArrayList<Object>(orig);
                    orig2.add(MetadataValuesRemapper.remapToPlatform(value, (Class)((ParameterizedType)m.getMethod().getParameters()[0].getParameterizedType()).getActualTypeArguments()[0]));
                    m.invoke(orig2);
                    return;
                }
                catch (Throwable orig2) {
                }
            }
        }
        if ((addMethod = Reflect.getMethodsCalled(meta, "add" + name.substring(0, name.length() - 1), 1)).isEmpty()) {
            addMethod = Reflect.getMethodsCalled(meta, "add" + name.substring(0, name.length() - 1), 2);
        }
        if (!addMethod.isEmpty()) {
            for (InstanceMethod m : addMethod) {
                try {
                    if (m.getMethod().getParameters().length == 2) {
                        m.invoke(MetadataValuesRemapper.remapToPlatform(value, m.getMethod().getParameterTypes()[0]), true);
                    } else {
                        m.invoke(MetadataValuesRemapper.remapToPlatform(value, m.getMethod().getParameterTypes()[0]));
                    }
                    return;
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

