/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.metadata;

import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.kyori.adventure.util.RGBLike;
import io.github.pronze.lib.screaminglib.bukkit.metadata.MetadataConverter;
import io.github.pronze.lib.screaminglib.firework.FireworkEffectHolder;
import io.github.pronze.lib.screaminglib.item.meta.EnchantmentHolder;
import io.github.pronze.lib.screaminglib.item.meta.PotionEffectHolder;
import io.github.pronze.lib.screaminglib.item.meta.PotionHolder;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;

public class MetadataValuesRemapper {
    private static final List<MetadataConverter<?>> CONVERTERS = List.of(new MetadataConverter<PotionHolder>(PotionHolder.class, PotionHolder::of, Wrapper::as), new MetadataConverter<RGBLike>(RGBLike.class, value -> {
        if (value instanceof Color) {
            return TextColor.color(((Color)value).getRed(), ((Color)value).getGreen(), ((Color)value).getBlue());
        }
        if (value instanceof DyeColor) {
            return TextColor.color(((DyeColor)value).getColor().getRed(), ((DyeColor)value).getColor().getGreen(), ((DyeColor)value).getColor().getBlue());
        }
        throw new UnsupportedOperationException("Can't remap " + value.getClass().getName() + " to RGBLike");
    }, (rgbLike, aClass) -> {
        if (aClass == Color.class) {
            return Color.fromRGB((int)rgbLike.red(), (int)rgbLike.green(), (int)rgbLike.blue());
        }
        if (aClass == DyeColor.class) {
            return DyeColor.getByColor((Color)Color.fromRGB((int)rgbLike.red(), (int)rgbLike.green(), (int)rgbLike.blue()));
        }
        throw new UnsupportedOperationException("Can't remap RGBLike to " + aClass.getName());
    }), new MetadataConverter<PotionEffectHolder>(PotionEffectHolder.class, PotionEffectHolder::of, Wrapper::as), new MetadataConverter<EnchantmentHolder>(EnchantmentHolder.class, EnchantmentHolder::of, Wrapper::as), new MetadataConverter<FireworkEffectHolder>(FireworkEffectHolder.class, FireworkEffectHolder::of, Wrapper::as), new MetadataConverter<NamespacedMappingKey>(NamespacedMappingKey.class, value -> NamespacedMappingKey.of(value.toString()), (namespacedMappingKey, aClass) -> {
        if (aClass == String.class) {
            return namespacedMappingKey.asString();
        }
        if (Reflect.has("org.bukkit.NamespacedKey") && aClass == NamespacedKey.class) {
            return new NamespacedKey(namespacedMappingKey.namespace(), namespacedMappingKey.value());
        }
        throw new UnsupportedOperationException("Can't remap NamespacedMappingKey to " + aClass.getName());
    }));

    public static Object remapToWrapper(Object object, Class<?> theResultClass) {
        if (object == null) {
            return null;
        }
        if (theResultClass.isPrimitive()) {
            if (theResultClass == Byte.TYPE) {
                theResultClass = Byte.class;
            } else if (theResultClass == Short.TYPE) {
                theResultClass = Short.class;
            } else if (theResultClass == Integer.TYPE) {
                theResultClass = Integer.class;
            } else if (theResultClass == Long.TYPE) {
                theResultClass = Long.class;
            } else if (theResultClass == Float.TYPE) {
                theResultClass = Float.class;
            } else if (theResultClass == Double.TYPE) {
                theResultClass = Double.class;
            } else if (theResultClass == Boolean.TYPE) {
                theResultClass = Boolean.class;
            } else if (theResultClass == Character.TYPE) {
                theResultClass = Character.class;
            } else if (theResultClass == Void.TYPE) {
                theResultClass = Void.class;
            }
        }
        if (theResultClass.isAssignableFrom(object.getClass())) {
            return object;
        }
        Class<Object> finalTheResultClass = theResultClass;
        return CONVERTERS.stream().filter(metadataConverter -> finalTheResultClass.equals(metadataConverter.getRequiredClass())).findFirst().orElseThrow().getMapToWrapper().apply(object);
    }

    public static Object remapToPlatform(Object object, Class<?> theResultClass) {
        if (object == null) {
            return null;
        }
        if (theResultClass.isPrimitive()) {
            if (theResultClass == Byte.TYPE) {
                theResultClass = Byte.class;
            } else if (theResultClass == Short.TYPE) {
                theResultClass = Short.class;
            } else if (theResultClass == Integer.TYPE) {
                theResultClass = Integer.class;
            } else if (theResultClass == Long.TYPE) {
                theResultClass = Long.class;
            } else if (theResultClass == Float.TYPE) {
                theResultClass = Float.class;
            } else if (theResultClass == Double.TYPE) {
                theResultClass = Double.class;
            } else if (theResultClass == Boolean.TYPE) {
                theResultClass = Boolean.class;
            } else if (theResultClass == Character.TYPE) {
                theResultClass = Character.class;
            } else if (theResultClass == Void.TYPE) {
                theResultClass = Void.class;
            }
        }
        if (theResultClass.isAssignableFrom(object.getClass())) {
            return object;
        }
        Class<Object> finalTheResultClass = theResultClass;
        return CONVERTERS.stream().filter(metadataConverter -> metadataConverter.getRequiredClass().isInstance(object)).findFirst().orElseThrow().getMapToPlatform().apply(object, finalTheResultClass);
    }
}

