/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.packet;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.exception.CancelEncoderException;
import io.github.pronze.lib.screaminglib.bukkit.packet.CraftBukkitPacketWriter;
import io.github.pronze.lib.screaminglib.bukkit.packet.listener.ServerboundInteractPacketListener;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.ClassStorage;
import io.github.pronze.lib.screaminglib.nms.accessors.ArmorStandAccessor;
import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.PacketMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.Preconditions;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.logger.LoggerWrapper;
import io.github.pronze.lib.screaminglib.vanilla.packet.PacketIdMapping;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.bukkit.Bukkit;

@Service(dependsOn={ServerboundInteractPacketListener.class})
public class BukkitPacketMapper
extends PacketMapper {
    private final LoggerWrapper logger;

    @Override
    public void sendPacket0(PlayerWrapper player, AbstractPacket packet) {
        Preconditions.checkNotNull(packet, "Cannot send null packet to player!");
        Preconditions.checkNotNull(player, "Cannot send packet to null player!");
        if (!player.isOnline()) {
            this.logger.trace("Player: {} is offline, ignoring packet: {}", player.getName(), packet.getClass().getSimpleName());
            return;
        }
        ByteBuf buffer = Unpooled.buffer();
        try {
            CraftBukkitPacketWriter writer = new CraftBukkitPacketWriter(buffer);
            writer.writeVarInt(packet.getId());
            int dataStartIndex = buffer.writerIndex();
            packet.write(writer);
            int dataSize = buffer.writerIndex() - dataStartIndex;
            if (dataSize > 0x1FFFFF) {
                throw new IllegalArgumentException("Packet too big (is " + dataSize + ", should be less than 2097152): " + packet);
            }
            Channel channel = player.getChannel();
            if (channel.isActive()) {
                if (Bukkit.getPluginManager().isPluginEnabled("ViaVersion")) {
                    UserConnection conn = Via.getAPI().getConnection(player.getUuid());
                    if (conn != null) {
                        try {
                            conn.transformClientbound(buffer, CancelEncoderException::generate);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        conn.sendRawPacket(buffer);
                    } else {
                        channel.eventLoop().execute(() -> channel.writeAndFlush((Object)buffer));
                    }
                } else if (Bukkit.getPluginManager().isPluginEnabled("OldCombatMechanics")) {
                    ChannelHandlerContext ctx = channel.pipeline().context("encoder");
                    if (ctx != null) {
                        channel.eventLoop().execute(() -> ctx.writeAndFlush((Object)buffer));
                    } else {
                        channel.eventLoop().execute(() -> channel.writeAndFlush((Object)buffer));
                    }
                } else {
                    channel.eventLoop().execute(() -> channel.writeAndFlush((Object)buffer));
                }
            }
            writer.getAppendedPackets().forEach(extraPacket -> this.sendPacket0(player, (AbstractPacket)extraPacket));
        }
        catch (Throwable t) {
            buffer.release();
            Bukkit.getLogger().severe("An exception occurred serializing packet of class: " + packet.getClass().getSimpleName() + " for player: " + player.getName());
            t.printStackTrace();
        }
    }

    @Override
    public int getId0(Class<? extends AbstractPacket> clazz) {
        return PacketIdMapping.getPacketId(clazz);
    }

    @Override
    public int getArmorStandTypeId0() {
        return ClassStorage.getEntityTypeId("armor_stand", ArmorStandAccessor.getType());
    }

    public BukkitPacketMapper(LoggerWrapper logger) {
        this.logger = logger;
    }
}

