/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.player;

import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.player.GenericCommandSender;
import io.github.pronze.lib.screaminglib.player.FinalOfflinePlayerWrapper;
import io.github.pronze.lib.screaminglib.player.OfflinePlayerWrapper;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.player.SenderWrapper;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.sender.Operator;
import io.github.pronze.lib.screaminglib.sender.permissions.AndPermission;
import io.github.pronze.lib.screaminglib.sender.permissions.OrPermission;
import io.github.pronze.lib.screaminglib.sender.permissions.Permission;
import io.github.pronze.lib.screaminglib.sender.permissions.PredicatePermission;
import io.github.pronze.lib.screaminglib.sender.permissions.SimplePermission;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;

@Service
public class BukkitPlayerMapper
extends PlayerMapper {
    public BukkitPlayerMapper() {
        this.offlinePlayerConverter.registerP2W(OfflinePlayer.class, offlinePlayer -> new FinalOfflinePlayerWrapper(offlinePlayer.getUniqueId(), offlinePlayer.getName())).registerP2W(PlayerWrapper.class, playerWrapper -> new FinalOfflinePlayerWrapper(playerWrapper.getUuid(), playerWrapper.getName())).registerW2P(OfflinePlayer.class, offlinePlayerWrapper -> Bukkit.getOfflinePlayer((UUID)offlinePlayerWrapper.getUuid())).registerW2P(PlayerWrapper.class, offlinePlayerWrapper -> this.getPlayer0(offlinePlayerWrapper.getUuid()).orElse(null));
        this.handConverter.registerW2P(EquipmentSlot.class, wrapper -> {
            if (wrapper == PlayerWrapper.Hand.OFF) {
                return EquipmentSlot.OFF_HAND;
            }
            return EquipmentSlot.HAND;
        }).registerP2W(EquipmentSlot.class, hand -> {
            if (hand == EquipmentSlot.OFF_HAND) {
                return PlayerWrapper.Hand.OFF;
            }
            return PlayerWrapper.Hand.MAIN;
        });
    }

    @Override
    public Optional<PlayerWrapper> getPlayer0(String name) {
        return Optional.ofNullable(Bukkit.getPlayer((String)name)).map(BukkitEntityPlayer::new);
    }

    @Override
    public Optional<PlayerWrapper> getPlayer0(UUID uuid) {
        return Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(BukkitEntityPlayer::new);
    }

    @Override
    protected <T> CommandSenderWrapper wrapSender0(T sender) {
        if (sender instanceof CommandSenderWrapper) {
            return (CommandSenderWrapper)sender;
        }
        if (sender instanceof OfflinePlayerWrapper) {
            return this.getPlayer0(((OfflinePlayerWrapper)sender).getUuid()).orElseThrow();
        }
        if (sender instanceof Player) {
            return new BukkitEntityPlayer((Player)sender);
        }
        if (sender instanceof OfflinePlayer) {
            return this.getPlayer0(((OfflinePlayer)sender).getUniqueId()).orElseThrow();
        }
        if (sender instanceof CommandSender) {
            return new GenericCommandSender((CommandSender)sender);
        }
        throw new UnsupportedOperationException("Can't wrap " + sender + " to CommandSenderWrapper");
    }

    @Override
    public SenderWrapper getConsoleSender0() {
        return new GenericCommandSender((CommandSender)Bukkit.getConsoleSender());
    }

    @Override
    public Optional<LocationHolder> getBedLocation0(OfflinePlayerWrapper playerWrapper) {
        return LocationMapper.resolve(playerWrapper.as(OfflinePlayer.class).getBedSpawnLocation());
    }

    @Override
    public boolean hasPermission0(CommandSenderWrapper wrapper, Permission permission) {
        if (this.isOp0(wrapper)) {
            return true;
        }
        if (permission instanceof SimplePermission) {
            if (this.isPermissionSet0(wrapper, permission)) {
                return wrapper.as(CommandSender.class).hasPermission(((SimplePermission)permission).getPermissionString());
            }
            return ((SimplePermission)permission).isDefaultAllowed();
        }
        if (permission instanceof AndPermission) {
            return ((AndPermission)permission).getPermissions().stream().allMatch(permission1 -> this.hasPermission0(wrapper, (Permission)permission1));
        }
        if (permission instanceof OrPermission) {
            return ((OrPermission)permission).getPermissions().stream().anyMatch(permission1 -> this.hasPermission0(wrapper, (Permission)permission1));
        }
        if (permission instanceof PredicatePermission) {
            return permission.hasPermission(wrapper);
        }
        return false;
    }

    @Override
    public boolean isPermissionSet0(CommandSenderWrapper wrapper, Permission permission) {
        if (permission instanceof SimplePermission) {
            return wrapper.as(CommandSender.class).isPermissionSet(((SimplePermission)permission).getPermissionString());
        }
        return true;
    }

    @Override
    public boolean isOp0(Operator wrapper) {
        return wrapper.as(CommandSender.class).isOp();
    }

    @Override
    public void setOp0(Operator wrapper, boolean op) {
        wrapper.as(CommandSender.class).setOp(op);
    }

    @Override
    public long getFirstPlayed0(OfflinePlayerWrapper playerWrapper) {
        return playerWrapper.as(OfflinePlayer.class).getFirstPlayed();
    }

    @Override
    public long getLastPlayed0(OfflinePlayerWrapper playerWrapper) {
        return playerWrapper.as(OfflinePlayer.class).getLastPlayed();
    }

    @Override
    public boolean isBanned0(OfflinePlayerWrapper playerWrapper) {
        return playerWrapper.as(OfflinePlayer.class).isBanned();
    }

    @Override
    public boolean isWhitelisted0(OfflinePlayerWrapper playerWrapper) {
        return playerWrapper.as(OfflinePlayer.class).isWhitelisted();
    }

    @Override
    public boolean isOnline0(OfflinePlayerWrapper playerWrapper) {
        return playerWrapper.as(OfflinePlayer.class).isOnline();
    }

    @Override
    public void setWhitelisted0(OfflinePlayerWrapper playerWrapper, boolean whitelisted) {
        playerWrapper.as(OfflinePlayer.class).setWhitelisted(whitelisted);
    }

    @Override
    public OfflinePlayerWrapper getOfflinePlayer0(UUID uuid) {
        OfflinePlayer offPlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        if (offPlayer instanceof Player) {
            return new BukkitEntityPlayer((Player)offPlayer);
        }
        return (OfflinePlayerWrapper)this.offlinePlayerConverter.convert(offPlayer);
    }

    @Override
    public Optional<OfflinePlayerWrapper> getOfflinePlayer0(String name) {
        OfflinePlayer offPlayer = Bukkit.getOfflinePlayer((String)name);
        if (offPlayer instanceof Player) {
            return Optional.of(new BukkitEntityPlayer((Player)offPlayer));
        }
        return this.offlinePlayerConverter.convertOptional(offPlayer);
    }

    @Override
    public Optional<PlayerWrapper> getPlayerExact0(String name) {
        return Optional.ofNullable(Bukkit.getPlayerExact((String)name)).map(BukkitEntityPlayer::new);
    }
}

