/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.plugin;

import io.github.pronze.lib.screaminglib.bukkit.plugin.BukkitPluginKey;
import io.github.pronze.lib.screaminglib.bukkit.plugin.event.PluginDisabledEventListener;
import io.github.pronze.lib.screaminglib.bukkit.plugin.event.PluginEnabledEventListener;
import io.github.pronze.lib.screaminglib.plugin.PluginDescription;
import io.github.pronze.lib.screaminglib.plugin.PluginKey;
import io.github.pronze.lib.screaminglib.plugin.PluginManager;
import io.github.pronze.lib.screaminglib.utils.Controllable;
import io.github.pronze.lib.screaminglib.utils.PlatformType;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.internal.InternalEarlyInitialization;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

@Service
@InternalEarlyInitialization
public class BukkitPluginManager
extends PluginManager {
    public static void init(JavaPlugin plugin, Controllable controllable) {
        PluginManager.init(BukkitPluginManager::new);
        controllable.enable(() -> {
            new PluginEnabledEventListener((Plugin)plugin);
            new PluginDisabledEventListener((Plugin)plugin);
        });
    }

    @Override
    protected Optional<Object> getPlatformClass0(PluginKey pluginKey) {
        return Optional.ofNullable(Bukkit.getPluginManager().getPlugin(pluginKey.as(String.class)));
    }

    @Override
    protected boolean isEnabled0(PluginKey pluginKey) {
        return Bukkit.getPluginManager().isPluginEnabled(pluginKey.as(String.class));
    }

    @Override
    protected Optional<PluginDescription> getPlugin0(PluginKey pluginKey) {
        return Optional.ofNullable(Bukkit.getPluginManager().getPlugin(pluginKey.as(String.class))).map(this::wrap);
    }

    @Override
    protected List<PluginDescription> getAllPlugins0() {
        return Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(this::wrap).collect(Collectors.toList());
    }

    @Override
    protected Optional<PluginKey> createKey0(Object identifier) {
        return Optional.of(BukkitPluginKey.of(identifier.toString()));
    }

    @Override
    protected PlatformType getPlatformType0() {
        return PlatformType.BUKKIT;
    }

    @Override
    protected Optional<PluginDescription> getPluginFromPlatformObject0(Object object) {
        return Arrays.stream(Bukkit.getPluginManager().getPlugins()).filter(a -> a == object).findFirst().map(this::wrap);
    }

    private PluginDescription wrap(Plugin plugin) {
        return new PluginDescription(BukkitPluginKey.of(plugin.getName()), plugin.getName(), plugin.getDescription().getVersion(), plugin.getDescription().getDescription(), plugin.getDescription().getAuthors(), plugin.getDescription().getDepend(), plugin.getDescription().getSoftDepend(), plugin.getDataFolder().toPath().toAbsolutePath());
    }
}

