/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.world;

import io.github.pronze.lib.screaminglib.bukkit.world.BukkitWorldHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.world.WorldHolder;
import io.github.pronze.lib.screaminglib.world.WorldMapper;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;

@Service
public class BukkitWorldMapper
extends WorldMapper {
    public BukkitWorldMapper() {
        this.converter.registerW2P(World.class, holder -> Bukkit.getWorld((UUID)holder.getUuid()));
        this.converter.registerP2W(World.class, BukkitWorldHolder::new);
    }

    @Override
    protected Optional<WorldHolder> getWorld0(UUID uuid) {
        return Optional.ofNullable(Bukkit.getWorld((UUID)uuid)).map(BukkitWorldHolder::new);
    }

    @Override
    protected Optional<WorldHolder> getWorld0(String name) {
        try {
            return this.getWorld0(UUID.fromString(name));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.ofNullable(Bukkit.getWorld((String)name)).map(BukkitWorldHolder::new);
        }
    }
}

