/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.world.gamerule;

import io.github.pronze.lib.screaminglib.bukkit.world.gamerule.BukkitGameRuleHolder;
import io.github.pronze.lib.screaminglib.bukkit.world.gamerule.BukkitLegacyGameRuleHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.lib.screaminglib.world.gamerule.GameRuleMapping;
import java.util.Arrays;
import java.util.List;
import org.bukkit.GameRule;

@Service
public class BukkitGameRuleMapping
extends GameRuleMapping {
    public BukkitGameRuleMapping() {
        if (Reflect.has("org.bukkit.GameRule")) {
            this.gameRuleConverter.registerP2W(GameRule.class, BukkitGameRuleHolder::new);
            Arrays.stream(GameRule.values()).forEach(gameRule -> {
                BukkitGameRuleHolder holder = new BukkitGameRuleHolder((GameRule<?>)gameRule);
                this.mapping.put(NamespacedMappingKey.of(gameRule.getName()), holder);
                this.values.add(holder);
            });
        } else {
            List.of("doFireTick", "mobGriefing", "keepInventory", "doMobSpawning", "doMobLoot", "doTileDrops", "commandBlockOutput", "naturalRegeneration", "doDaylightCycle", "logAdminCommands", "showDeathMessages", "randomTickSpeed", "sendCommandFeedback", "reducedDebugInfo", "doEntityDrops", "spectatorsGenerateChunks", "spawnRadius", "disableElytraMovementCheck", "doWeatherCycle", "maxEntityCramming", "doLimitedCrafting", "maxCommandChainLength", "announceAdvancements", "gameLoopFunction").forEach(gameRule -> {
                BukkitLegacyGameRuleHolder holder = new BukkitLegacyGameRuleHolder((String)gameRule);
                this.mapping.put(NamespacedMappingKey.of(gameRule), holder);
                this.values.add(holder);
            });
        }
    }
}

