/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.command;

import io.github.pronze.lib.cloud.CommandManager;
import io.github.pronze.lib.cloud.CommandTree;
import io.github.pronze.lib.cloud.execution.CommandExecutionCoordinator;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
public abstract class CloudConstructor {
    private static CloudConstructor cloudConstructor;

    @ApiStatus.Internal
    public static void init(Supplier<CloudConstructor> cloudConstructorSupplier) {
        if (cloudConstructor != null) {
            throw new UnsupportedOperationException("CloudConstructor has been already initialized!");
        }
        cloudConstructor = cloudConstructorSupplier.get();
    }

    public static boolean isInitialized() {
        return cloudConstructor != null;
    }

    public static CommandManager<CommandSenderWrapper> construct(Function<CommandTree<CommandSenderWrapper>, CommandExecutionCoordinator<CommandSenderWrapper>> commandCoordinator) throws Exception {
        if (cloudConstructor == null) {
            throw new UnsupportedOperationException("CloudConstructor is not initialized yet!");
        }
        return cloudConstructor.construct0(commandCoordinator);
    }

    public abstract CommandManager<CommandSenderWrapper> construct0(Function<CommandTree<CommandSenderWrapper>, CommandExecutionCoordinator<CommandSenderWrapper>> var1) throws Exception;
}

