/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.configurate;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.kyori.adventure.text.format.NamedTextColor;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.kyori.adventure.util.RGBLike;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScreamingSerializer {
    @Nullable
    protected TextColor deserializeColor(ConfigurationNode colorNode) {
        if (colorNode.isMap()) {
            return TextColor.color(colorNode.node("red").getInt(colorNode.node("RED").getInt()), colorNode.node("green").getInt(colorNode.node("GREEN").getInt()), colorNode.node("blue").getInt(colorNode.node("BLUE").getInt()));
        }
        String color = colorNode.getString("");
        TextColor c = TextColor.fromCSSHexString(color);
        if (c != null) {
            return c;
        }
        NamedTextColor named = NamedTextColor.NAMES.value(color.toLowerCase().trim());
        if (named != null) {
            return named;
        }
        try {
            Integer number = colorNode.get(Integer.class);
            if (number != null) {
                return TextColor.color(number);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected void serializeColor(TextColor color, ConfigurationNode node) throws SerializationException {
        if (color instanceof NamedTextColor) {
            node.set(NamedTextColor.NAMES.key((NamedTextColor)color));
        } else {
            NamedTextColor exact = NamedTextColor.ofExact(color.value());
            if (exact != null) {
                node.set(NamedTextColor.NAMES.key(exact));
            } else {
                node.set(color.asHexString());
            }
        }
    }

    protected void serializeColor(RGBLike color, ConfigurationNode node) throws SerializationException {
        if (color instanceof TextColor) {
            this.serializeColor((TextColor)color, node);
        } else {
            this.serializeColor(TextColor.color(color.red(), color.green(), color.blue()), node);
        }
    }
}

