/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.configurate;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.serialize.TypeSerializer;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.kyori.adventure.util.RGBLike;
import io.github.pronze.lib.screaminglib.configurate.AbstractScreamingSerializer;
import io.github.pronze.lib.screaminglib.firework.FireworkEffectHolder;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FireworkEffectHolderSerializer
extends AbstractScreamingSerializer
implements TypeSerializer<FireworkEffectHolder> {
    private static final String TYPE_KEY = "type";
    private static final String FLICKER_KEY = "flicker";
    private static final String TRAIL_KEY = "trail";
    private static final String COLORS_KEY = "colors";
    private static final String FADE_COLORS_KEY = "fade-colors";
    public static final FireworkEffectHolderSerializer INSTANCE = new FireworkEffectHolderSerializer();

    @Override
    public FireworkEffectHolder deserialize(Type type, ConfigurationNode node) throws SerializationException {
        try {
            TextColor color;
            if (!node.isMap()) {
                return FireworkEffectHolder.of(node.getString());
            }
            ConfigurationNode effectNode = node.node(TYPE_KEY);
            ConfigurationNode flickerNode = node.node(FLICKER_KEY);
            ConfigurationNode trailNode = node.node(TRAIL_KEY);
            ConfigurationNode colorsNode = node.node(COLORS_KEY);
            ConfigurationNode fadeColorsNode = node.node(FADE_COLORS_KEY);
            FireworkEffectHolder holder = FireworkEffectHolder.of(effectNode.getString()).withFlicker(flickerNode.getBoolean(true)).withTrail(trailNode.getBoolean(true));
            if (!colorsNode.empty()) {
                if (colorsNode.isList()) {
                    holder = holder.withColors(colorsNode.childrenList().stream().map(this::deserializeColor).filter(Objects::nonNull).collect(Collectors.toList()));
                } else {
                    color = this.deserializeColor(colorsNode);
                    if (color != null) {
                        holder = holder.withColors(List.of(color));
                    }
                }
            }
            if (!fadeColorsNode.empty()) {
                if (fadeColorsNode.isList()) {
                    holder = holder.withFadeColors(fadeColorsNode.childrenList().stream().map(this::deserializeColor).filter(Objects::nonNull).collect(Collectors.toList()));
                } else {
                    color = this.deserializeColor(fadeColorsNode);
                    if (color != null) {
                        holder = holder.withFadeColors(List.of(color));
                    }
                }
            }
            return holder;
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    @Override
    public void serialize(Type type, @Nullable FireworkEffectHolder obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        node.node(TYPE_KEY).set(obj.platformName());
        node.node(FLICKER_KEY).set(obj.flicker());
        node.node(TRAIL_KEY).set(obj.trail());
        for (RGBLike color : obj.colors()) {
            this.serializeColor(color, node.node(COLORS_KEY).appendListNode());
        }
        for (RGBLike color : obj.fadeColors()) {
            this.serializeColor(color, node.node(FADE_COLORS_KEY).appendListNode());
        }
    }
}

