/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.container;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.container.Container;
import io.github.pronze.lib.screaminglib.container.type.InventoryTypeHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
public abstract class ContainerFactory {
    private static ContainerFactory factory;

    @ApiStatus.Internal
    public ContainerFactory() {
        if (factory != null) {
            throw new UnsupportedOperationException("ContainerFactory is already initialized.");
        }
        factory = this;
    }

    public static <C extends Container> Optional<C> wrapContainer(Object container) {
        if (factory == null) {
            throw new UnsupportedOperationException("ContainerFactory is not initialized yet.");
        }
        return factory.wrapContainer0(container);
    }

    public abstract <C extends Container> Optional<C> wrapContainer0(Object var1);

    public static <C extends Container> Optional<C> createContainer(InventoryTypeHolder type) {
        if (factory == null) {
            throw new UnsupportedOperationException("ContainerFactory is not initialized yet.");
        }
        return factory.createContainer0(type);
    }

    public static <C extends Container> Optional<C> createContainer(InventoryTypeHolder type, Component name) {
        if (factory == null) {
            throw new UnsupportedOperationException("ContainerFactory is not initialized yet.");
        }
        return factory.createContainer0(type, name);
    }

    public static <C extends Container> Optional<C> createContainer(int size) {
        if (factory == null) {
            throw new UnsupportedOperationException("ContainerFactory is not initialized yet.");
        }
        return factory.createContainer0(size);
    }

    public static <C extends Container> Optional<C> createContainer(int size, Component name) {
        if (factory == null) {
            throw new UnsupportedOperationException("ContainerFactory is not initialized yet.");
        }
        return factory.createContainer0(size, name);
    }

    public abstract <C extends Container> Optional<C> createContainer0(InventoryTypeHolder var1);

    public abstract <C extends Container> Optional<C> createContainer0(InventoryTypeHolder var1, Component var2);

    public abstract <C extends Container> Optional<C> createContainer0(int var1);

    public abstract <C extends Container> Optional<C> createContainer0(int var1, Component var2);
}

