/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.entity;

import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityExperience;
import io.github.pronze.lib.screaminglib.entity.EntityItem;
import io.github.pronze.lib.screaminglib.entity.EntityLightning;
import io.github.pronze.lib.screaminglib.entity.type.EntityTypeHolder;
import io.github.pronze.lib.screaminglib.entity.type.EntityTypeMapping;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.meta.PotionEffectMapping;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ServiceDependencies;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
@ServiceDependencies(dependsOn={EntityTypeMapping.class, LocationMapper.class, PotionEffectMapping.class})
public abstract class EntityMapper {
    private static EntityMapper mapper;

    @ApiStatus.Internal
    public EntityMapper() {
        if (mapper != null) {
            throw new UnsupportedOperationException("EntityMapper is already initialized");
        }
        mapper = this;
    }

    public static <T extends EntityBasic> Optional<T> wrapEntity(Object entity) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        if (entity instanceof EntityBasic) {
            return Optional.of((EntityBasic)entity);
        }
        return mapper.wrapEntity0(entity);
    }

    public static <T extends EntityBasic> Optional<T> spawn(Object entityType, LocationHolder locationHolder) {
        if (entityType instanceof EntityTypeHolder) {
            return EntityMapper.spawn((EntityTypeHolder)entityType, locationHolder);
        }
        Optional<EntityTypeHolder> type = EntityTypeMapping.resolve(entityType);
        if (type.isPresent()) {
            return EntityMapper.spawn(type.get(), locationHolder);
        }
        return Optional.empty();
    }

    public static <T extends EntityBasic> Optional<T> spawn(EntityTypeHolder entityType, LocationHolder locationHolder) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.spawn0(entityType, locationHolder);
    }

    public static Optional<EntityItem> dropItem(Item item, LocationHolder locationHolder) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.dropItem0(item, locationHolder);
    }

    public static Optional<EntityExperience> dropExperience(int experience, LocationHolder locationHolder) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.dropExperience0(experience, locationHolder);
    }

    public static Optional<EntityLightning> strikeLightning(LocationHolder locationHolder) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.strikeLightning0(locationHolder);
    }

    public static int getNewEntityId() {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        if (!Server.isServerThread()) {
            throw new UnsupportedOperationException("EntityMapper#getNewEntityId() method must be called from the Server thread!, or use EntityMapper#getNewEntityIdSynchronously() instead");
        }
        return mapper.getNewEntityId0();
    }

    public static CompletableFuture<Integer> getNewEntityIdSynchronously() {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.getNewEntityIdSynchronously0();
    }

    protected abstract <T extends EntityBasic> Optional<T> wrapEntity0(Object var1);

    public abstract <T extends EntityBasic> Optional<T> spawn0(EntityTypeHolder var1, LocationHolder var2);

    public abstract Optional<EntityItem> dropItem0(Item var1, LocationHolder var2);

    public abstract Optional<EntityExperience> dropExperience0(int var1, LocationHolder var2);

    public abstract Optional<EntityLightning> strikeLightning0(LocationHolder var1);

    public abstract int getNewEntityId0();

    public abstract CompletableFuture<Integer> getNewEntityIdSynchronously0();
}

