/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.entity.pose;

import io.github.pronze.lib.screaminglib.entity.pose.EntityPoseMapping;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.RawValueHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.LimitedVersionSupport;
import java.util.List;
import java.util.Optional;

@LimitedVersionSupport(value="Bukkit >= 1.17")
public interface EntityPoseHolder
extends ComparableWrapper,
RawValueHolder {
    @Deprecated(forRemoval=true)
    default public String getPlatformName() {
        return this.platformName();
    }

    public String platformName();

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.ENTITY_POSE)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.ENTITY_POSE)
    public boolean is(Object ... var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.ENTITY_POSE)
    public static EntityPoseHolder of(Object entityPose) {
        return EntityPoseHolder.ofOptional(entityPose).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.ENTITY_POSE)
    public static Optional<EntityPoseHolder> ofOptional(Object entityPose) {
        if (entityPose instanceof EntityPoseHolder) {
            return Optional.of((EntityPoseHolder)entityPose);
        }
        return EntityPoseMapping.resolve(entityPose);
    }

    public static List<EntityPoseHolder> all() {
        return EntityPoseMapping.getValues();
    }
}

