/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.entity.type;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.EntityTypeHolderSerializer;
import io.github.pronze.lib.screaminglib.entity.type.EntityTypeHolder;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostConstruct;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<subPackage>[^\\.]+\\.[^\\.]+)\\.(?<className>.+)$")
public abstract class EntityTypeMapping
extends AbstractTypeMapper<EntityTypeHolder> {
    private static EntityTypeMapping entityTypeMapping;
    protected final BidirectionalConverter<EntityTypeHolder> entityTypeConverter = BidirectionalConverter.build().registerP2W(EntityTypeHolder.class, e -> e).registerP2W(ConfigurationNode.class, node -> {
        try {
            return EntityTypeHolderSerializer.INSTANCE.deserialize((Type)((Object)EntityTypeHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
            return null;
        }
    });

    @ApiStatus.Internal
    public EntityTypeMapping() {
        if (entityTypeMapping != null) {
            throw new UnsupportedOperationException("EntityTypeMapping is already initialized.");
        }
        entityTypeMapping = this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.ENTITY_TYPE)
    @OfMethodAlternative(value=EntityTypeHolder.class, methodName="ofOptional")
    public static Optional<EntityTypeHolder> resolve(Object entity) {
        if (entityTypeMapping == null) {
            throw new UnsupportedOperationException("EntityTypeMapping is not initialized yet.");
        }
        if (entity == null) {
            return Optional.empty();
        }
        return EntityTypeMapping.entityTypeMapping.entityTypeConverter.convertOptional(entity).or(() -> entityTypeMapping.resolveFromMapping(entity));
    }

    @OfMethodAlternative(value=EntityTypeHolder.class, methodName="all")
    public static List<EntityTypeHolder> getValues() {
        if (entityTypeMapping == null) {
            throw new UnsupportedOperationException("EntityTypeMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(EntityTypeMapping.entityTypeMapping.values);
    }

    @OnPostConstruct
    public void legacyMapping() {
        this.mapAlias("ITEM", "DROPPED_ITEM");
        this.mapAlias("LEASH_KNOT", "LEASH_HITCH");
        this.mapAlias("EYE_OF_ENDER", "ENDER_SIGNAL");
        this.mapAlias("POTION", "SPLASH_POTION");
        this.mapAlias("EXPERIENCE_BOTTLE", "THROWN_EXP_BOTTLE");
        this.mapAlias("TNT", "PRIMED_TNT");
        this.mapAlias("FIREWORK_ROCKET", "FIREWORK");
        this.mapAlias("COMMAND_BLOCK_MINECART", "MINECART_COMMAND");
        this.mapAlias("CHEST_MINECART", "MINECART_CHEST");
        this.mapAlias("FURNACE_MINECART", "MINECART_FURNACE");
        this.mapAlias("TNT_MINECART", "MINECART_TNT");
        this.mapAlias("HOPPER_MINECART", "MINECART_HOPPER");
        this.mapAlias("SPAWNER_MINECART", "MINECART_MOB_SPAWNER");
        this.mapAlias("MOOSHROOM", "MUSHROOM_COW");
        this.mapAlias("SNOW_GOLEM", "SNOWMAN");
        this.mapAlias("END_CRYSTAL", "ENDER_CRYSTAL");
        this.mapAlias("FISHING_BOBBER", "FISHING_HOOK");
        this.mapAlias("LIGHTNING_BOLT", "LIGHTNING");
    }
}

