/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.event.player;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.event.PlatformEventWrapper;
import io.github.pronze.lib.screaminglib.event.SCancellableEvent;
import io.github.pronze.lib.screaminglib.event.SEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerEvent;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.item.ItemView;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotHolder;
import io.github.pronze.lib.screaminglib.utils.BlockFace;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SPlayerInteractEvent
extends SCancellableEvent,
SPlayerEvent,
PlatformEventWrapper {
    @Nullable
    public ItemView item();

    public Action action();

    @Nullable
    public BlockHolder clickedBlock();

    public BlockFace blockFace();

    public SEvent.Result useClickedBlock();

    public void useClickedBlock(SEvent.Result var1);

    public SEvent.Result useItemInHand();

    public void useItemInHand(SEvent.Result var1);

    @Nullable
    public EquipmentSlotHolder hand();

    @Override
    default public void cancelled(boolean cancel) {
        this.useClickedBlock(cancel ? SEvent.Result.DENY : (this.useClickedBlock() == SEvent.Result.DENY ? SEvent.Result.DEFAULT : this.useClickedBlock()));
        this.useItemInHand(cancel ? SEvent.Result.DENY : (this.useItemInHand() == SEvent.Result.DENY ? SEvent.Result.DEFAULT : this.useItemInHand()));
    }

    default public boolean hasBlock() {
        return this.clickedBlock() != null;
    }

    default public boolean hasItem() {
        return this.item() != null;
    }

    @NotNull
    default public ItemTypeHolder material() {
        if (!this.hasItem()) {
            return ItemTypeHolder.air();
        }
        return this.item().getMaterial();
    }

    @Override
    @Deprecated
    default public boolean cancelled() {
        return this.useClickedBlock() == SEvent.Result.DENY;
    }

    public static enum Action {
        LEFT_CLICK_BLOCK,
        RIGHT_CLICK_BLOCK,
        LEFT_CLICK_AIR,
        RIGHT_CLICK_AIR,
        PHYSICAL;

        public static List<Action> VALUES;

        public static Action convert(String name) {
            return VALUES.stream().filter(next -> next.name().equalsIgnoreCase(name)).findFirst().orElse(LEFT_CLICK_AIR);
        }

        static {
            VALUES = Arrays.asList(Action.values());
        }
    }
}

