/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.firework;

import io.github.pronze.lib.kyori.adventure.util.RGBLike;
import io.github.pronze.lib.screaminglib.firework.FireworkEffectMapping;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Contract;

public interface FireworkEffectHolder
extends ComparableWrapper {
    public String platformName();

    public List<RGBLike> colors();

    public List<RGBLike> fadeColors();

    public boolean flicker();

    public boolean trail();

    @Contract(value="_ -> new", pure=true)
    public FireworkEffectHolder withColors(List<RGBLike> var1);

    @Contract(value="_ -> new", pure=true)
    public FireworkEffectHolder withFadeColors(List<RGBLike> var1);

    @Contract(value="_ -> new", pure=true)
    public FireworkEffectHolder withFlicker(boolean var1);

    @Contract(value="_ -> new", pure=true)
    public FireworkEffectHolder withTrail(boolean var1);

    @Deprecated(forRemoval=true)
    default public String getPlatformName() {
        return this.platformName();
    }

    @Deprecated(forRemoval=true)
    default public List<RGBLike> getColors() {
        return this.colors();
    }

    @Deprecated(forRemoval=true)
    default public List<RGBLike> getFadeColors() {
        return this.fadeColors();
    }

    @Deprecated(forRemoval=true)
    default public boolean isFlicker() {
        return this.flicker();
    }

    @Deprecated(forRemoval=true)
    default public boolean isTrail() {
        return this.trail();
    }

    @Deprecated(forRemoval=true)
    default public FireworkEffectHolder colors(List<RGBLike> colors) {
        return this.withColors(colors);
    }

    @Deprecated(forRemoval=true)
    default public FireworkEffectHolder fadeColors(List<RGBLike> fadeColors) {
        return this.withFadeColors(fadeColors);
    }

    @Deprecated(forRemoval=true)
    default public FireworkEffectHolder flicker(boolean flicker) {
        return this.withFlicker(flicker);
    }

    @Deprecated(forRemoval=true)
    default public FireworkEffectHolder trail(boolean trail) {
        return this.withTrail(trail);
    }

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.FIREWORK_EFFECT)
    public boolean is(Object ... var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.FIREWORK_EFFECT)
    public boolean is(Object var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.FIREWORK_EFFECT)
    public static FireworkEffectHolder of(Object effect) {
        return FireworkEffectHolder.ofOptional(effect).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.FIREWORK_EFFECT)
    public static Optional<FireworkEffectHolder> ofOptional(Object effect) {
        if (effect instanceof FireworkEffectHolder) {
            return Optional.of((FireworkEffectHolder)effect);
        }
        return FireworkEffectMapping.resolve(effect);
    }

    public static List<FireworkEffectHolder> all() {
        return FireworkEffectMapping.getValues();
    }
}

