/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.firework;

import io.github.pronze.lib.configurate.BasicConfigurationNode;
import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.FireworkEffectHolderSerializer;
import io.github.pronze.lib.screaminglib.firework.FireworkEffectHolder;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostConstruct;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
public abstract class FireworkEffectMapping
extends AbstractTypeMapper<FireworkEffectHolder> {
    private static FireworkEffectMapping fireworkEffectMapping = null;
    protected BidirectionalConverter<FireworkEffectHolder> fireworkEffectConverter = BidirectionalConverter.build().registerP2W(FireworkEffectHolder.class, e -> e).registerP2W(ConfigurationNode.class, node -> {
        try {
            return FireworkEffectHolderSerializer.INSTANCE.deserialize((Type)((Object)FireworkEffectHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException e) {
            e.printStackTrace();
            return null;
        }
    }).registerP2W(Map.class, map -> {
        try {
            FireworkEffectHolderSerializer.INSTANCE.deserialize((Type)((Object)FireworkEffectHolder.class), BasicConfigurationNode.root().set(map));
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
        return null;
    });

    @ApiStatus.Internal
    public FireworkEffectMapping() {
        if (fireworkEffectMapping != null) {
            throw new UnsupportedOperationException("FireworkEffectMapping is already initialized.");
        }
        fireworkEffectMapping = this;
    }

    @OnPostConstruct
    public void postConstruct() {
        this.mapAlias("SMALL", "BALL");
        this.mapAlias("LARGE", "BALL_LARGE");
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.FIREWORK_EFFECT)
    @OfMethodAlternative(value=FireworkEffectHolder.class, methodName="ofOptional")
    public static Optional<FireworkEffectHolder> resolve(Object fireworkEffectObject) {
        if (fireworkEffectMapping == null) {
            throw new UnsupportedOperationException("FireworkEffectMapping is not initialized yet.");
        }
        if (fireworkEffectObject == null) {
            return Optional.empty();
        }
        return FireworkEffectMapping.fireworkEffectMapping.fireworkEffectConverter.convertOptional(fireworkEffectObject).or(() -> fireworkEffectMapping.resolveFromMapping(fireworkEffectObject));
    }

    @OfMethodAlternative(value=FireworkEffectHolder.class, methodName="all")
    public static List<FireworkEffectHolder> getValues() {
        if (fireworkEffectMapping == null) {
            throw new UnsupportedOperationException("FireworkEffectMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(FireworkEffectMapping.fireworkEffectMapping.values);
    }
}

