/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.healthindicator;

import io.github.pronze.lib.screaminglib.Core;
import io.github.pronze.lib.screaminglib.event.OnEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerLeaveEvent;
import io.github.pronze.lib.screaminglib.healthindicator.HealthIndicator;
import io.github.pronze.lib.screaminglib.healthindicator.HealthIndicatorImpl;
import io.github.pronze.lib.screaminglib.packet.PacketMapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPreDisable;
import io.github.pronze.lib.screaminglib.visuals.Visual;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;

@Service(dependsOn={Core.class, PacketMapper.class})
public class HealthIndicatorManager {
    private static HealthIndicatorManager manager;
    protected final Map<UUID, HealthIndicator> activeIndicators = new HashMap<UUID, HealthIndicator>();

    @ApiStatus.Internal
    public HealthIndicatorManager() {
        if (manager != null) {
            throw new UnsupportedOperationException("HealthIndicatorManager is already initialized!");
        }
        manager = this;
    }

    public static Map<UUID, HealthIndicator> getActiveIndicators() {
        if (manager == null) {
            throw new UnsupportedOperationException("HealthIndicatorManager is not initialized yet!");
        }
        return Map.copyOf(HealthIndicatorManager.manager.activeIndicators);
    }

    public static Optional<HealthIndicator> getHealthIndicator(UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("HealthIndicatorManager is not initialized yet!");
        }
        return Optional.ofNullable(HealthIndicatorManager.manager.activeIndicators.get(uuid));
    }

    public static void addHealthIndicator(HealthIndicator healthIndicator) {
        if (manager == null) {
            throw new UnsupportedOperationException("HealthIndicatorManager is not initialized yet!");
        }
        HealthIndicatorManager.manager.activeIndicators.put(healthIndicator.uuid(), healthIndicator);
    }

    public static void removeHealthIndicator(UUID uuid) {
        HealthIndicatorManager.getHealthIndicator(uuid).ifPresent(HealthIndicatorManager::removeHealthIndicator);
    }

    public static void removeHealthIndicator(HealthIndicator healthIndicator) {
        if (manager == null) {
            throw new UnsupportedOperationException("HealthIndicatorManager is not initialized yet!");
        }
        HealthIndicatorManager.manager.activeIndicators.remove(healthIndicator.uuid());
    }

    public static HealthIndicator healthIndicator() {
        return HealthIndicatorManager.healthIndicator(UUID.randomUUID());
    }

    public static HealthIndicator healthIndicator(UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("HealthIndicatorManager is not initialized yet!");
        }
        HealthIndicator healthIndicator = manager.healthIndicator0(uuid);
        HealthIndicatorManager.addHealthIndicator(healthIndicator);
        return healthIndicator;
    }

    protected HealthIndicator healthIndicator0(UUID uuid) {
        return new HealthIndicatorImpl(uuid);
    }

    @OnPreDisable
    public void destroy() {
        HealthIndicatorManager.getActiveIndicators().values().forEach(Visual::destroy);
        HealthIndicatorManager.manager.activeIndicators.clear();
    }

    @OnEvent
    public void onLeave(SPlayerLeaveEvent event) {
        if (this.activeIndicators.isEmpty()) {
            return;
        }
        HealthIndicatorManager.getActiveIndicators().forEach((key, indicator) -> {
            if (indicator.viewers().contains(event.player())) {
                indicator.removeViewer(event.player());
                indicator.removeTrackedPlayer(event.player());
            }
            if (!indicator.hasViewers()) {
                HealthIndicatorManager.removeHealthIndicator(indicator);
            }
        });
    }
}

