/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item;

import com.iamceph.resulter.core.pack.ProtoWrapper;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.attribute.ItemAttributeHolder;
import io.github.pronze.lib.screaminglib.item.HideFlags;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.item.builder.ItemBuilder;
import io.github.pronze.lib.screaminglib.item.data.ItemData;
import io.github.pronze.lib.screaminglib.item.meta.EnchantmentHolder;
import io.github.pronze.lib.screaminglib.metadata.MetadataProvider;
import io.github.pronze.lib.screaminglib.particle.ParticleData;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.ProtoItem;
import io.github.pronze.lib.screaminglib.utils.RawValueHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Item
extends ComparableWrapper,
RawValueHolder,
ParticleData,
Cloneable,
MetadataProvider,
ProtoWrapper<ProtoItem> {
    public ItemTypeHolder getType();

    default public ItemTypeHolder getMaterial() {
        return this.getType();
    }

    public int getAmount();

    @Nullable
    public Component getDisplayName();

    public List<Component> getLore();

    public List<ItemAttributeHolder> getAttributeModifiers();

    default public List<ItemAttributeHolder> getItemAttributes() {
        return this.getAttributeModifiers();
    }

    public List<EnchantmentHolder> getEnchantments();

    public ItemData getData();

    public List<HideFlags> getHideFlags();

    @Deprecated
    default public List<String> getItemFlags() {
        return this.getHideFlags().stream().map(HideFlags::getBukkitName).collect(Collectors.toList());
    }

    public Integer getCustomModelData();

    public boolean isUnbreakable();

    public int getRepairCost();

    default public int getRepair() {
        return this.getRepairCost();
    }

    public ItemBuilder builder();

    default public boolean isAir() {
        return this.getType().isAir();
    }

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.MATERIAL)
    default public boolean is(Object ... objects) {
        return this.getType().is(objects);
    }

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.MATERIAL)
    default public boolean is(Object object) {
        return this.getType().is(object);
    }

    public boolean isSimilar(Item var1);

    @Contract(value="_ -> new", pure=true)
    default public Item withType(@NotNull ItemTypeHolder type) {
        return this.builder().type(type).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withAmount(int amount) {
        return this.builder().amount(amount).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withDisplayName(@Nullable Component displayName) {
        return this.builder().displayName(displayName).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withItemLore(@Nullable List<@NotNull Component> lore) {
        return this.builder().itemLore(lore).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withAttributeModifiers(@Nullable List<@NotNull ItemAttributeHolder> modifiers) {
        return this.builder().attributeModifiers(modifiers).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withAttributeModifier(@NotNull ItemAttributeHolder modifier) {
        return this.builder().attributeModifier(modifier).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withData(@NotNull ItemData data) {
        return this.builder().data(data).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withHideFlags(@Nullable List<@NotNull HideFlags> flags) {
        return this.builder().hideFlags(flags).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withHideFlag(@NotNull HideFlags flag) {
        return this.builder().hideFlag(flag).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withEnchantments(@Nullable List<@NotNull EnchantmentHolder> enchantments) {
        return this.builder().enchantments(enchantments).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withEnchantment(@NotNull EnchantmentHolder enchantment) {
        return this.builder().enchantment(enchantment).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withCustomModelData(@Nullable Integer customModelData) {
        return this.builder().customModelData(customModelData).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withUnbreakable(boolean unbreakable) {
        return this.builder().unbreakable(unbreakable).build().orElseThrow();
    }

    @Contract(value="_ -> new", pure=true)
    default public Item withRepairCost(int repairCost) {
        return this.builder().repairCost(repairCost).build().orElseThrow();
    }

    public Item clone();

    @Override
    default public ProtoItem asProto() {
        List<Component> lore;
        ProtoItem.Builder builder = ProtoItem.newBuilder();
        builder.setType(this.getType().asProto()).setAmount(this.getAmount());
        Component displayName = this.getDisplayName();
        if (displayName != null) {
            builder.setDisplayName(AdventureHelper.toJson(displayName));
        }
        if ((lore = this.getLore()) != null) {
            builder.addAllLore(lore.stream().map(AdventureHelper::toJson).collect(Collectors.toList()));
        }
        builder.addAllAttributeModifiers(this.getAttributeModifiers().stream().map(ProtoWrapper::asProto).collect(Collectors.toList())).addAllEnchantments(this.getEnchantments().stream().map(ProtoWrapper::asProto).collect(Collectors.toList())).addAllHideFlags(this.getHideFlags().stream().map(Enum::name).collect(Collectors.toList())).setCustomModelData(this.getCustomModelData()).setUnbreakable(this.isUnbreakable()).setRepairCost(this.getRepairCost());
        return builder.build();
    }
}

