/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item;

import com.iamceph.resulter.core.pack.ProtoWrapper;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.item.ItemTypeMapper;
import io.github.pronze.lib.screaminglib.particle.ParticleData;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.ProtoItemType;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.LimitedVersionSupport;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Contract;

public interface ItemTypeHolder
extends ComparableWrapper,
ProtoWrapper<ProtoItemType>,
ParticleData {
    public String platformName();

    @Deprecated(forRemoval=true)
    default public short durability() {
        return this.forcedDurability();
    }

    @Deprecated
    @LimitedVersionSupport(value="<= 1.12.2")
    public short forcedDurability();

    default public boolean isAir() {
        return this.equals(ItemTypeHolder.air());
    }

    public int maxStackSize();

    @Deprecated(forRemoval=true)
    default public ItemTypeHolder withDurability(short durability) {
        return this.withForcedDurability(durability);
    }

    @Deprecated
    @LimitedVersionSupport(value="<= 1.12.2")
    @Contract(value="_ -> new", pure=true)
    public ItemTypeHolder withForcedDurability(short var1);

    @Deprecated(forRemoval=true)
    default public int getMaxStackSize() {
        return this.maxStackSize();
    }

    default public ItemTypeHolder colorize(String color) {
        return ItemTypeMapper.colorize(this, color);
    }

    public Optional<BlockTypeHolder> block();

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.MATERIAL)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.MATERIAL)
    public boolean is(Object ... var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.MATERIAL)
    public static ItemTypeHolder of(Object type) {
        return ItemTypeHolder.ofOptional(type).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.MATERIAL)
    public static Optional<ItemTypeHolder> ofOptional(Object type) {
        if (type instanceof ItemTypeHolder) {
            return Optional.of((ItemTypeHolder)type);
        }
        return ItemTypeMapper.resolve(type);
    }

    public static ItemTypeHolder air() {
        return ItemTypeMapper.getCachedAir();
    }

    public static List<ItemTypeHolder> all() {
        return ItemTypeMapper.getValues();
    }

    @Override
    default public ProtoItemType asProto() {
        return ProtoItemType.newBuilder().setPlatformName(this.platformName()).setDurability(this.durability()).build();
    }
}

