/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item.builder;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.kyori.adventure.text.format.NamedTextColor;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.kyori.adventure.util.RGBLike;
import io.github.pronze.lib.screaminglib.attribute.AttributeMapping;
import io.github.pronze.lib.screaminglib.attribute.ItemAttributeHolder;
import io.github.pronze.lib.screaminglib.firework.FireworkEffectHolder;
import io.github.pronze.lib.screaminglib.item.HideFlags;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.ItemMeta;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.item.builder.ShortStackDeserializer;
import io.github.pronze.lib.screaminglib.item.data.ItemData;
import io.github.pronze.lib.screaminglib.item.meta.EnchantmentHolder;
import io.github.pronze.lib.screaminglib.item.meta.PotionEffectHolder;
import io.github.pronze.lib.screaminglib.item.meta.PotionHolder;
import io.github.pronze.lib.screaminglib.metadata.MetadataCollectionKey;
import io.github.pronze.lib.screaminglib.metadata.MetadataConsumer;
import io.github.pronze.lib.screaminglib.metadata.MetadataKey;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ItemBuilder
extends MetadataConsumer {
    public ItemBuilder type(@NotNull ItemTypeHolder var1);

    public ItemBuilder durability(int var1);

    public ItemBuilder amount(int var1);

    public ItemBuilder displayName(@Nullable Component var1);

    public ItemBuilder itemLore(@Nullable List<@NotNull Component> var1);

    public ItemBuilder attributeModifiers(@Nullable List<@NotNull ItemAttributeHolder> var1);

    public ItemBuilder attributeModifier(@NotNull ItemAttributeHolder var1);

    public ItemBuilder data(@NotNull ItemData var1);

    public ItemBuilder hideFlags(@Nullable List<@NotNull HideFlags> var1);

    public ItemBuilder hideFlag(@NotNull HideFlags var1);

    public ItemBuilder enchantments(@Nullable List<@NotNull EnchantmentHolder> var1);

    public ItemBuilder enchantment(@NotNull EnchantmentHolder var1);

    public ItemBuilder customModelData(@Nullable Integer var1);

    public ItemBuilder unbreakable(boolean var1);

    public ItemBuilder repairCost(int var1);

    public Optional<Item> build();

    @Deprecated
    public ItemBuilder platformMeta(Object var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.MATERIAL)
    default public ItemBuilder type(@NotNull Object type) {
        if (type instanceof ItemTypeHolder) {
            return this.type((ItemTypeHolder)type);
        }
        ShortStackDeserializer.deserializeShortStack(this, type);
        return this;
    }

    default public ItemBuilder name(@NotNull Component name) {
        return this.displayName(name);
    }

    default public ItemBuilder name(@NotNull ComponentLike name) {
        return this.displayName(name.asComponent());
    }

    default public ItemBuilder name(@Nullable String name) {
        return this.displayName(name == null ? null : AdventureHelper.toComponent(name));
    }

    default public ItemBuilder localizedName(@Nullable String name) {
        return this.displayName(name == null ? null : Component.translatable(name));
    }

    default public ItemBuilder repair(int repair) {
        return this.repairCost(repair);
    }

    default public <C> ItemBuilder flags(@Nullable List<C> flags) {
        if (flags == null) {
            return this;
        }
        return this.hideFlags(flags.stream().map(o -> {
            if (o instanceof HideFlags) {
                return (HideFlags)((Object)((Object)o));
            }
            return HideFlags.convert(o.toString());
        }).collect(Collectors.toList()));
    }

    public ItemBuilder lore(@NotNull Component var1);

    default public ItemBuilder lore(@NotNull ComponentLike component) {
        return this.lore(component.asComponent());
    }

    default public ItemBuilder lore(@Nullable String lore) {
        return this.lore(lore == null ? Component.empty() : AdventureHelper.toComponent(lore));
    }

    default public <C> ItemBuilder lore(@NotNull List<C> lore) {
        return this.itemLore(lore.stream().map(c -> {
            if (c instanceof ComponentLike) {
                return ((ComponentLike)c).asComponent();
            }
            return c == null ? Component.empty() : AdventureHelper.toComponent(c.toString());
        }).collect(Collectors.toList()));
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.ENCHANTMENT)
    default public ItemBuilder enchant(@NotNull Object enchant, int level) {
        return this.enchant(enchant + " " + level);
    }

    default public ItemBuilder enchant(@NotNull Map<Object, Integer> enchants) {
        enchants.forEach(this::enchant);
        return this;
    }

    default public ItemBuilder enchant(@NotNull List<Object> enchants) {
        enchants.forEach(this::enchant);
        return this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.ENCHANTMENT)
    default public ItemBuilder enchant(@NotNull Object enchant) {
        EnchantmentHolder.ofOptional(enchant).ifPresent(this::enchantment);
        return this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION)
    default public ItemBuilder potion(@NotNull Object potion) {
        PotionHolder.ofOptional(potion).ifPresent(potionHolder -> this.setMetadata((MetadataKey)ItemMeta.POTION_TYPE, potionHolder));
        return this;
    }

    default public ItemBuilder attribute(@NotNull Object itemAttribute) {
        AttributeMapping.wrapItemAttribute(itemAttribute).ifPresent(this::attributeModifier);
        return this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION_EFFECT)
    default public ItemBuilder effect(@NotNull Object effect) {
        if (effect instanceof List) {
            List list = (List)effect;
            list.forEach(effect1 -> PotionEffectHolder.ofOptional(effect1).ifPresent(potionEffectHolder -> this.addToListMetadata((MetadataCollectionKey)ItemMeta.CUSTOM_POTION_EFFECTS, potionEffectHolder)));
            return this;
        }
        PotionEffectHolder.ofOptional(effect).ifPresent(potionEffectHolder -> this.addToListMetadata((MetadataCollectionKey)ItemMeta.CUSTOM_POTION_EFFECTS, potionEffectHolder));
        return this;
    }

    default public ItemBuilder recipe(@NotNull String key) {
        return this.recipe(NamespacedMappingKey.of(key));
    }

    default public ItemBuilder recipe(@NotNull NamespacedMappingKey key) {
        this.addToListMetadata((MetadataCollectionKey)ItemMeta.RECIPES, key);
        return this;
    }

    default public ItemBuilder color(@NotNull String color) {
        TextColor c = TextColor.fromCSSHexString(color);
        if (c != null) {
            return this.color(c);
        }
        NamedTextColor c2 = NamedTextColor.NAMES.value(color.toLowerCase().trim());
        if (c2 != null) {
            return this.color(c2);
        }
        return this;
    }

    default public ItemBuilder color(@NotNull RGBLike color) {
        if (this.supportsMetadata(ItemMeta.CUSTOM_POTION_COLOR)) {
            this.setMetadata((MetadataKey)ItemMeta.CUSTOM_POTION_COLOR, color);
        } else {
            this.setMetadata((MetadataKey)ItemMeta.COLOR, color);
        }
        return this;
    }

    default public ItemBuilder color(int r, int g, int b) {
        return this.color(TextColor.color(r, g, b));
    }

    default public ItemBuilder skullOwner(@Nullable String skullOwner) {
        this.setMetadata((MetadataKey)ItemMeta.SKULL_OWNER, skullOwner);
        return this;
    }

    default public ItemBuilder fireworkEffect(@NotNull Object effect) {
        if (effect instanceof List) {
            List list = (List)effect;
            list.forEach(effect1 -> FireworkEffectHolder.ofOptional(effect1).ifPresent(fireworkEffectHolder -> this.addToListMetadata((MetadataCollectionKey)ItemMeta.FIREWORK_EFFECTS, fireworkEffectHolder)));
            return this;
        }
        FireworkEffectHolder.ofOptional(effect).ifPresent(fireworkEffectHolder -> {
            if (this.supportsMetadata(ItemMeta.FIREWORK_EFFECTS)) {
                this.addToListMetadata((MetadataCollectionKey)ItemMeta.FIREWORK_EFFECTS, fireworkEffectHolder);
            } else {
                this.setMetadata((MetadataKey)ItemMeta.FIREWORK_STAR_EFFECT, fireworkEffectHolder);
            }
        });
        return this;
    }

    default public ItemBuilder power(int power) {
        this.setMetadata((MetadataKey)ItemMeta.FIREWORK_POWER, (Object)power);
        return this;
    }

    default public ItemBuilder damage(int damage) {
        return this.durability(damage);
    }

    @Override
    public <T> ItemBuilder setMetadata(MetadataKey<T> var1, T var2);

    @Override
    public <T> ItemBuilder setMetadata(MetadataCollectionKey<T> var1, Collection<T> var2);

    @Override
    public <T> ItemBuilder addToListMetadata(MetadataCollectionKey<T> var1, T var2);
}

