/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item.builder;

import io.github.pronze.lib.configurate.BasicConfigurationNode;
import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.kyori.adventure.text.format.NamedTextColor;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.screaminglib.attribute.AttributeMapping;
import io.github.pronze.lib.screaminglib.firework.FireworkEffectHolder;
import io.github.pronze.lib.screaminglib.firework.FireworkEffectMapping;
import io.github.pronze.lib.screaminglib.item.HideFlags;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.item.ItemTypeMapper;
import io.github.pronze.lib.screaminglib.item.ItemView;
import io.github.pronze.lib.screaminglib.item.builder.ItemBuilder;
import io.github.pronze.lib.screaminglib.item.builder.ShortStackDeserializer;
import io.github.pronze.lib.screaminglib.item.meta.EnchantmentHolder;
import io.github.pronze.lib.screaminglib.item.meta.EnchantmentMapping;
import io.github.pronze.lib.screaminglib.item.meta.PotionEffectHolder;
import io.github.pronze.lib.screaminglib.item.meta.PotionEffectMapping;
import io.github.pronze.lib.screaminglib.item.meta.PotionHolder;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.ConfigurateUtils;
import io.github.pronze.lib.screaminglib.utils.ReceiverConsumer;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ServiceDependencies;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<subPackage>[^\\.]+\\.[^\\.]+)\\.(?<className>.+)$")
@ServiceDependencies(dependsOn={ItemTypeMapper.class})
public abstract class ItemFactory {
    private static final Function<ConfigurationNode, Item> CONFIGURATE_RESOLVER = node -> {
        ConfigurationNode power;
        ConfigurationNode fireworkEffects;
        ConfigurationNode color;
        ConfigurationNode recipes;
        ConfigurationNode attributes;
        ConfigurationNode potionEffects;
        ConfigurationNode potionType;
        ConfigurationNode enchants;
        ConfigurationNode lore;
        ConfigurationNode unbreakable;
        ConfigurationNode itemFlags;
        ConfigurationNode repairCost;
        ConfigurationNode customModelData;
        ConfigurationNode locName;
        ConfigurationNode displayName;
        ConfigurationNode durability;
        ConfigurationNode damage;
        ConfigurationNode amount;
        if (!node.isMap()) {
            return ItemFactory.readStack(node.getString()).orElse(null);
        }
        ItemBuilder builder = ItemFactory.builder();
        ConfigurationNode type = node.node("type");
        ShortStackDeserializer.deserializeShortStack(builder, type.getString());
        ConfigurationNode meta = node.node("meta");
        if (!meta.empty()) {
            builder.platformMeta(ConfigurateUtils.toMap(meta));
        }
        if (!(amount = node.node("amount")).empty()) {
            builder.amount(amount.getInt(1));
        }
        if (!(damage = node.node("damage")).empty()) {
            builder.durability(damage.getInt(0));
        }
        if (!(durability = node.node("durability")).empty()) {
            builder.durability(durability.getInt(0));
        }
        if (!(displayName = node.node("display-name")).empty()) {
            builder.displayName(AdventureHelper.toComponent(Objects.requireNonNull(displayName.getString())));
        }
        if (!(locName = node.node("loc-name")).empty()) {
            builder.localizedName(locName.getString());
        }
        if (!(customModelData = node.node("custom-model-data")).empty()) {
            try {
                builder.customModelData(locName.get(Integer.class));
            }
            catch (SerializationException serializationException) {
                // empty catch block
            }
        }
        if (!(repairCost = node.node("repair-cost")).empty()) {
            builder.repairCost(repairCost.getInt());
        }
        if (!(itemFlags = node.node("ItemFlags")).empty()) {
            if (itemFlags.isList()) {
                try {
                    builder.flags(itemFlags.getList(String.class));
                }
                catch (SerializationException e) {
                    e.printStackTrace();
                }
            } else {
                builder.hideFlag(HideFlags.convert(itemFlags.getString("")));
            }
        }
        if (!(unbreakable = node.node("Unbreakable")).empty()) {
            builder.unbreakable(unbreakable.getBoolean(false));
        }
        if (!(lore = node.node("lore")).empty()) {
            if (lore.isList()) {
                try {
                    List<String> list = Objects.requireNonNull(lore.getList(String.class));
                    builder.lore(list);
                }
                catch (SerializationException e) {
                    e.printStackTrace();
                }
            } else {
                builder.lore(lore.getString());
            }
        }
        if (!(enchants = node.node("enchants")).empty()) {
            if (enchants.isMap()) {
                enchants.childrenMap().entrySet().stream().map(EnchantmentMapping::resolve).filter(Optional::isPresent).map(Optional::get).forEach(builder::enchantment);
            } else if (enchants.isList()) {
                try {
                    enchants.getList(Object.class).stream().map(EnchantmentMapping::resolve).filter(Optional::isPresent).map(Optional::get).forEach(builder::enchantment);
                }
                catch (SerializationException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    EnchantmentHolder.ofOptional(enchants.get(Object.class)).ifPresent(builder::enchantment);
                }
                catch (SerializationException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!(potionType = node.node("potion-type")).empty()) {
            try {
                PotionHolder.ofOptional(potionType.get(Object.class)).ifPresent(builder::potion);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(potionEffects = node.node("effects")).empty()) {
            if (potionEffects.isList()) {
                builder.effect(potionEffects.childrenList().stream().map(PotionEffectMapping::resolve).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
            } else {
                PotionEffectHolder.ofOptional(potionEffects).ifPresent(builder::effect);
            }
        }
        if (!(attributes = node.node("attributes")).empty()) {
            if (attributes.isList()) {
                attributes.childrenList().stream().map(AttributeMapping::wrapItemAttribute).filter(Optional::isPresent).map(Optional::get).forEach(builder::attributeModifier);
            } else {
                AttributeMapping.wrapItemAttribute(attributes).ifPresent(builder::attributeModifier);
            }
        }
        if (!(recipes = node.node("recipes")).empty()) {
            if (recipes.isList()) {
                attributes.childrenList().stream().map(ConfigurationNode::getString).map(NamespacedMappingKey::ofOptional).filter(Optional::isPresent).map(Optional::get).forEach(builder::recipe);
            } else {
                NamespacedMappingKey.ofOptional(recipes.getString()).ifPresent(builder::recipe);
            }
        }
        if (!(color = node.node("color")).empty()) {
            TextColor c = TextColor.fromCSSHexString(color.getString(""));
            if (c != null) {
                builder.color(c);
            } else {
                NamedTextColor c2 = NamedTextColor.NAMES.value(color.getString("").trim().toLowerCase());
                if (c2 != null) {
                    builder.color(c2);
                }
            }
        }
        if (!(fireworkEffects = node.node("firework-effects")).empty()) {
            if (fireworkEffects.isList()) {
                builder.fireworkEffect(fireworkEffects.childrenList().stream().map(FireworkEffectMapping::resolve).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
            } else {
                FireworkEffectHolder.ofOptional(fireworkEffects).ifPresent(builder::fireworkEffect);
            }
        }
        if (!(power = node.node("power")).empty()) {
            builder.power(power.getInt());
        }
        return builder.build().orElse(null);
    };
    protected BidirectionalConverter<Item> itemConverter = BidirectionalConverter.build().registerW2P(String.class, item -> item.getMaterial().platformName()).registerW2P(ItemTypeHolder.class, Item::getMaterial).registerP2W(ConfigurationNode.class, CONFIGURATE_RESOLVER).registerP2W(Map.class, map -> {
        try {
            return CONFIGURATE_RESOLVER.apply(BasicConfigurationNode.root().set(map));
        }
        catch (SerializationException e) {
            e.printStackTrace();
            return null;
        }
    }).registerP2W(Item.class, Item::clone);
    private static ItemFactory factory;
    private static Item cachedAir;

    @ApiStatus.Internal
    public ItemFactory() {
        if (factory != null) {
            throw new UnsupportedOperationException("ItemFactory is already initialized.");
        }
        factory = this;
    }

    public static ItemBuilder builder() {
        if (factory == null) {
            throw new UnsupportedOperationException("ItemFactory is not initialized yet.");
        }
        return factory.builder0();
    }

    public static ItemView asView(Item item) {
        if (factory == null) {
            throw new UnsupportedOperationException("ItemFactory is not initialized yet.");
        }
        return factory.asView0(item);
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.MATERIAL)
    public static Optional<Item> build(Object stack) {
        return ItemFactory.readStack(stack);
    }

    public static Optional<Item> build(ReceiverConsumer<ItemBuilder> builderConsumer) {
        ItemBuilder builder = ItemFactory.builder();
        builderConsumer.accept(builder);
        return builder.build();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.MATERIAL)
    public static Optional<Item> build(Object stack, ReceiverConsumer<ItemBuilder> builderConsumer) {
        Optional<Item> item = ItemFactory.readStack(stack);
        if (item.isEmpty()) {
            return Optional.empty();
        }
        if (builderConsumer != null) {
            ItemBuilder builder = item.get().builder();
            builderConsumer.accept(builder);
            return builder.build();
        }
        return item;
    }

    public static Optional<Item> readStack(Object stackObject) {
        Optional<Item> it = ItemFactory.factory.itemConverter.convertOptional(stackObject);
        if (it.isPresent()) {
            return it;
        }
        return ItemFactory.readShortStack(ItemFactory.builder(), stackObject);
    }

    public static Optional<Item> readShortStack(Item item, Object shortStackObject) {
        ItemBuilder builder = item.builder();
        ShortStackDeserializer.deserializeShortStack(builder, shortStackObject);
        return builder.build();
    }

    public static Optional<Item> readShortStack(ItemBuilder builder, Object shortStackObject) {
        ShortStackDeserializer.deserializeShortStack(builder, shortStackObject);
        return builder.build();
    }

    public static List<Item> buildAll(List<Object> objects) {
        return objects.stream().map(o -> ItemFactory.build(o).orElse(ItemFactory.getAir())).collect(Collectors.toList());
    }

    public static Item getAir() {
        if (cachedAir == null) {
            cachedAir = ItemFactory.build("AIR").orElseThrow();
        }
        return cachedAir.clone();
    }

    public static <T> T convertItem(Item item, Class<T> newType) {
        if (factory == null) {
            throw new UnsupportedOperationException("ItemFactory is not initialized yet.");
        }
        return ItemFactory.factory.itemConverter.convert(item, newType);
    }

    protected abstract ItemBuilder builder0();

    protected abstract ItemView asView0(Item var1);
}

