/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item.builder;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.item.builder.ItemBuilder;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ShortStackDeserializer {
    public static final Pattern SHORT_STACK_PATTERN = Pattern.compile("^(?<material>(?:(?!(?<!\\\\)(?:\\\\\\\\)*;).)+)(\\\\*)?(;(?<amount>(?:(?!(?<!\\\\)(?:\\\\\\\\)*;).)+)?(\\\\*)?(;(?<name>(\"((?!(?<!\\\\)(?:\\\\\\\\)*\").)+|(?:(?!(?<!\\\\)(?:\\\\\\\\)*;).)+))?(\\\\*)?(;(?<lore>.*))?)?)?$");
    public static final Pattern LORE_SPLIT = Pattern.compile("((\"((?!(?<!\\\\)(?:\\\\\\\\)*\").)+\")|((?!(?<!\\\\)(?:\\\\\\\\)*;).)+)(?=($|;))");

    public static void deserializeShortStack(ItemBuilder builder, Object shortStackObject) {
        Optional<ItemTypeHolder> materialHolder;
        Matcher matcher;
        Optional<ItemTypeHolder> opt;
        if (shortStackObject instanceof ConfigurationNode) {
            shortStackObject = ((ConfigurationNode)shortStackObject).getString();
        }
        if (!(shortStackObject instanceof String) && (opt = ItemTypeHolder.ofOptional(shortStackObject)).isPresent()) {
            builder.type(opt.get());
            return;
        }
        if (shortStackObject == null) {
            return;
        }
        String shortStack = shortStackObject.toString().trim();
        if (shortStack.startsWith("(cast to ItemStack)")) {
            shortStack = shortStack.substring(19).trim();
        }
        if (!(matcher = SHORT_STACK_PATTERN.matcher(shortStack)).matches() || matcher.group("material") == null) {
            return;
        }
        String material = matcher.group("material");
        String amount = matcher.group("amount");
        String name = matcher.group("name");
        if (name != null && name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        String loreString = matcher.group("lore");
        ArrayList<String> lore = new ArrayList<String>();
        if (loreString != null) {
            Matcher loreMatcher = LORE_SPLIT.matcher(loreString);
            while (loreMatcher.find()) {
                lore.add(loreMatcher.group());
            }
        }
        if ((materialHolder = ItemTypeHolder.ofOptional(material)).isEmpty()) {
            return;
        }
        builder.type(materialHolder.get());
        try {
            if (amount != null && !amount.trim().isEmpty()) {
                builder.amount(Integer.parseInt(amount.trim()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (name != null && !name.trim().isEmpty()) {
            builder.displayName(AdventureHelper.toComponent(name.trim()));
        }
        builder.itemLore(lore.stream().map(AdventureHelper::toComponent).collect(Collectors.toList()));
    }
}

