/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item.meta;

import com.iamceph.resulter.core.pack.ProtoWrapper;
import io.github.pronze.lib.screaminglib.item.meta.EnchantmentMapping;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.ProtoEnchantment;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Contract;

public interface EnchantmentHolder
extends ComparableWrapper,
ProtoWrapper<ProtoEnchantment> {
    public String platformName();

    public int level();

    @Contract(value="_ -> new", pure=true)
    public EnchantmentHolder withLevel(int var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.ENCHANTMENT)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.ENCHANTMENT)
    public boolean is(Object ... var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.ENCHANTMENT)
    public boolean isSameType(Object var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.ENCHANTMENT)
    public boolean isSameType(Object ... var1);

    @Deprecated(forRemoval=true)
    @CustomAutocompletion(value=CustomAutocompletion.Type.ENCHANTMENT)
    default public boolean isType(Object object) {
        return this.isSameType(object);
    }

    @Deprecated(forRemoval=true)
    @CustomAutocompletion(value=CustomAutocompletion.Type.ENCHANTMENT)
    default public boolean isType(Object ... objects) {
        return this.isSameType(objects);
    }

    @Deprecated(forRemoval=true)
    default public String getPlatformName() {
        return this.platformName();
    }

    @Deprecated(forRemoval=true)
    default public int getLevel() {
        return this.level();
    }

    @Deprecated(forRemoval=true)
    default public EnchantmentHolder newLevel(int level) {
        return this.withLevel(level);
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.ENCHANTMENT)
    public static EnchantmentHolder of(Object enchantment) {
        return EnchantmentHolder.ofOptional(enchantment).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.ENCHANTMENT)
    public static Optional<EnchantmentHolder> ofOptional(Object enchantment) {
        if (enchantment instanceof EnchantmentHolder) {
            return Optional.of((EnchantmentHolder)enchantment);
        }
        return EnchantmentMapping.resolve(enchantment);
    }

    public static List<EnchantmentHolder> all() {
        return EnchantmentMapping.getValues();
    }

    @Override
    default public ProtoEnchantment asProto() {
        return ProtoEnchantment.newBuilder().setPlatformName(this.platformName()).setLevel(this.level()).build();
    }
}

