/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item.meta;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.EnchantmentHolderSerializer;
import io.github.pronze.lib.screaminglib.item.meta.EnchantmentHolder;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.RomanToDecimal;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostConstruct;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<subPackage>[^\\.]+\\.[^\\.]+)\\.(?<className>.+)$")
public abstract class EnchantmentMapping
extends AbstractTypeMapper<EnchantmentHolder> {
    private static final Pattern RESOLUTION_PATTERN = Pattern.compile("^(?<namespaced>[A-Za-z][A-Za-z0-9_.\\-/:]*)(\\s+(?<level>(\\d+|(?=[MDCLXVI])M*(C[MD]|D?C*)(X[CL]|L?X*)(I[XV]|V?I*)))?)?$");
    private static EnchantmentMapping enchantmentMapping;
    protected BidirectionalConverter<EnchantmentHolder> enchantmentConverter = BidirectionalConverter.build().registerP2W(EnchantmentHolder.class, e -> e).registerP2W(Map.Entry.class, entry -> {
        Optional<EnchantmentHolder> holder = EnchantmentMapping.resolve(entry.getKey());
        if (holder.isPresent()) {
            int level;
            if (entry.getValue() instanceof Number) {
                level = ((Number)entry.getValue()).intValue();
            } else if (entry.getValue() instanceof ConfigurationNode) {
                try {
                    level = Integer.parseInt(((ConfigurationNode)entry.getValue()).getString("1"));
                }
                catch (Throwable t) {
                    level = RomanToDecimal.romanToDecimal(((ConfigurationNode)entry.getValue()).getString("I"));
                }
            } else {
                try {
                    level = Integer.parseInt(entry.getValue().toString());
                }
                catch (Throwable t) {
                    level = RomanToDecimal.romanToDecimal(entry.getValue().toString());
                }
            }
            return holder.get().withLevel(level);
        }
        return null;
    }).registerP2W(ConfigurationNode.class, node -> {
        try {
            return EnchantmentHolderSerializer.INSTANCE.deserialize((Type)((Object)EnchantmentHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException e) {
            e.printStackTrace();
            return null;
        }
    });

    @CustomAutocompletion(value=CustomAutocompletion.Type.FIREWORK_EFFECT)
    @OfMethodAlternative(value=EnchantmentHolder.class, methodName="ofOptional")
    public static Optional<EnchantmentHolder> resolve(Object enchantmentObject) {
        if (enchantmentMapping == null) {
            throw new UnsupportedOperationException("Enchantment mapping is not initialized yet.");
        }
        if (enchantmentObject == null) {
            return Optional.empty();
        }
        return EnchantmentMapping.enchantmentMapping.enchantmentConverter.convertOptional(enchantmentObject).or(() -> {
            String enchantment = enchantmentObject.toString().trim();
            Matcher matcher = RESOLUTION_PATTERN.matcher(enchantment);
            if (matcher.matches() && matcher.group("namespaced") != null) {
                NamespacedMappingKey namespaced = NamespacedMappingKey.of(matcher.group("namespaced"));
                String level_str = matcher.group("level");
                if (EnchantmentMapping.enchantmentMapping.mapping.containsKey(namespaced)) {
                    if (level_str != null && !level_str.isEmpty()) {
                        int level;
                        try {
                            level = Integer.parseInt(level_str);
                        }
                        catch (Throwable t) {
                            level = RomanToDecimal.romanToDecimal(level_str);
                        }
                        return Optional.of(((EnchantmentHolder)EnchantmentMapping.enchantmentMapping.mapping.get(namespaced)).withLevel(level));
                    }
                    return Optional.of((EnchantmentHolder)EnchantmentMapping.enchantmentMapping.mapping.get(namespaced));
                }
            }
            return Optional.empty();
        });
    }

    @OfMethodAlternative(value=EnchantmentHolder.class, methodName="all")
    public static List<EnchantmentHolder> getValues() {
        if (enchantmentMapping == null) {
            throw new UnsupportedOperationException("EnchantmentMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(EnchantmentMapping.enchantmentMapping.values);
    }

    protected EnchantmentMapping() {
        if (enchantmentMapping != null) {
            throw new UnsupportedOperationException("Enchantment mapping is already initialized.");
        }
        enchantmentMapping = this;
    }

    @OnPostConstruct
    public void legacyMapping() {
        this.mapAlias("POWER", "ARROW_DAMAGE");
        this.mapAlias("FLAME", "ARROW_FIRE");
        this.mapAlias("INFINITY", "ARROW_INFINITE");
        this.mapAlias("PUNCH", "ARROW_KNOCKBACK");
        this.mapAlias("SHARPNESS", "DAMAGE_ALL");
        this.mapAlias("BANE_OF_ARTHROPODS", "DAMAGE_ARTHROPODS");
        this.mapAlias("SMITE", "DAMAGE_UNDEAD");
        this.mapAlias("EFFICIENCY", "DIG_SPEED");
        this.mapAlias("UNBREAKING", "DURABILITY");
        this.mapAlias("FORTUNE", "LOOT_BONUS_BLOCKS");
        this.mapAlias("LOOTING", "LOOT_BONUS_MOBS");
        this.mapAlias("LUCK_OF_THE_SEA", "LUCK");
        this.mapAlias("RESPIRATION", "OXYGEN");
        this.mapAlias("PROTECTION", "PROTECTION_ENVIRONMENTAL");
        this.mapAlias("BLAST_PROTECTION", "PROTECTION_EXPLOSIONS");
        this.mapAlias("FEATHER_FALLING", "PROTECTION_FALL");
        this.mapAlias("FIRE_PROTECTION", "PROTECTION_FIRE");
        this.mapAlias("PROJECTILE_PROTECTION", "PROTECTION_PROJECTILE");
        this.mapAlias("SWEEPING", "SWEEPING_EDGE");
        this.mapAlias("AQUA_AFFINITY", "WATER_WORKER");
    }
}

