/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item.meta;

import com.iamceph.resulter.core.pack.ProtoWrapper;
import io.github.pronze.lib.screaminglib.item.meta.PotionEffectMapping;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.ProtoPotionEffect;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Contract;

public interface PotionEffectHolder
extends ComparableWrapper,
ProtoWrapper<ProtoPotionEffect> {
    public String platformName();

    public int duration();

    public int amplifier();

    public boolean ambient();

    public boolean particles();

    public boolean icon();

    @Deprecated(forRemoval=true)
    default public String getPlatformName() {
        return this.platformName();
    }

    @Deprecated(forRemoval=true)
    default public int getDuration() {
        return this.duration();
    }

    @Deprecated(forRemoval=true)
    default public int getAmplifier() {
        return this.amplifier();
    }

    @Deprecated(forRemoval=true)
    default public boolean isAmbient() {
        return this.ambient();
    }

    @Deprecated(forRemoval=true)
    default public boolean isParticles() {
        return this.particles();
    }

    @Deprecated(forRemoval=true)
    default public boolean isIcon() {
        return this.icon();
    }

    @Contract(value="_ -> new", pure=true)
    public PotionEffectHolder withDuration(int var1);

    @Deprecated(forRemoval=true)
    @Contract(value="_ -> new", pure=true)
    default public PotionEffectHolder duration(int duration) {
        return this.withDuration(duration);
    }

    @Contract(value="_ -> new", pure=true)
    public PotionEffectHolder withAmplifier(int var1);

    @Deprecated(forRemoval=true)
    @Contract(value="_ -> new", pure=true)
    default public PotionEffectHolder amplifier(int amplifier) {
        return this.withAmplifier(amplifier);
    }

    @Contract(value="_ -> new", pure=true)
    public PotionEffectHolder withAmbient(boolean var1);

    @Deprecated(forRemoval=true)
    @Contract(value="_ -> new", pure=true)
    default public PotionEffectHolder ambient(boolean ambient) {
        return this.withAmbient(ambient);
    }

    @Contract(value="_ -> new", pure=true)
    public PotionEffectHolder withParticles(boolean var1);

    @Deprecated(forRemoval=true)
    @Contract(value="_ -> new", pure=true)
    default public PotionEffectHolder particles(boolean particles) {
        return this.withParticles(particles);
    }

    @Contract(value="_ -> new", pure=true)
    public PotionEffectHolder withIcon(boolean var1);

    @Deprecated(forRemoval=true)
    @Contract(value="_ -> new", pure=true)
    default public PotionEffectHolder icon(boolean icon) {
        return this.withIcon(icon);
    }

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION_EFFECT)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION_EFFECT)
    public boolean is(Object ... var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION_EFFECT)
    public boolean isSameType(Object var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION_EFFECT)
    public boolean isSameType(Object ... var1);

    @Deprecated(forRemoval=true)
    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION_EFFECT)
    default public boolean isType(Object object) {
        return this.isSameType(object);
    }

    @Deprecated(forRemoval=true)
    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION_EFFECT)
    default public boolean isType(Object ... objects) {
        return this.isSameType(objects);
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION_EFFECT)
    public static PotionEffectHolder of(Object effect) {
        return PotionEffectHolder.ofOptional(effect).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION_EFFECT)
    public static Optional<PotionEffectHolder> ofOptional(Object effect) {
        if (effect instanceof PotionEffectHolder) {
            return Optional.of((PotionEffectHolder)effect);
        }
        return PotionEffectMapping.resolve(effect);
    }

    public static List<PotionEffectHolder> all() {
        return PotionEffectMapping.getValues();
    }

    @Override
    default public ProtoPotionEffect asProto() {
        return ProtoPotionEffect.newBuilder().setPlatformName(this.platformName()).setAmplifier(this.amplifier()).setDuration(this.duration()).setAmbient(this.ambient()).setIcon(this.icon()).setParticles(this.particles()).build();
    }
}

