/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item.meta;

import io.github.pronze.lib.configurate.BasicConfigurationNode;
import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.PotionEffectHolderSerializer;
import io.github.pronze.lib.screaminglib.item.meta.PotionEffectHolder;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.RomanToDecimal;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostConstruct;
import io.github.pronze.lib.screaminglib.utils.key.MappingKey;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import io.github.pronze.lib.screaminglib.utils.key.NumericMappingKey;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<subPackage>[^\\.]+\\.[^\\.]+)\\.(?<className>.+)$")
public abstract class PotionEffectMapping
extends AbstractTypeMapper<PotionEffectHolder> {
    private static final Pattern RESOLUTION_PATTERN = Pattern.compile("^(?<namespaced>[A-Za-z0-9_.\\-/:]+)(\\s+(?<duration>(\\d+|(?=[MDCLXVI])M*(C[MD]|D?C*)(X[CL]|L?X*)(I[XV]|V?I*)))?)?$");
    private static PotionEffectMapping potionEffectMapping;
    protected BidirectionalConverter<PotionEffectHolder> potionEffectConverter = BidirectionalConverter.build().registerP2W(PotionEffectHolder.class, e -> e).registerP2W(Map.class, map -> {
        try {
            return PotionEffectHolderSerializer.INSTANCE.deserialize((Type)((Object)PotionEffectHolder.class), BasicConfigurationNode.root().set(map));
        }
        catch (SerializationException e) {
            e.printStackTrace();
            return null;
        }
    }).registerP2W(ConfigurationNode.class, node -> {
        try {
            return PotionEffectHolderSerializer.INSTANCE.deserialize((Type)((Object)PotionEffectHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException e) {
            e.printStackTrace();
            return null;
        }
    });

    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION_EFFECT)
    @OfMethodAlternative(value=PotionEffectHolder.class, methodName="ofOptional")
    public static Optional<PotionEffectHolder> resolve(Object potionEffectObject) {
        if (potionEffectMapping == null) {
            throw new UnsupportedOperationException("PotionEffect mapping is not initialized yet.");
        }
        if (potionEffectObject == null) {
            return Optional.empty();
        }
        return PotionEffectMapping.potionEffectMapping.potionEffectConverter.convertOptional(potionEffectObject).or(() -> {
            String potionEffect = potionEffectObject.toString().trim();
            Matcher matcher = RESOLUTION_PATTERN.matcher(potionEffect);
            if (matcher.matches() && matcher.group("namespaced") != null) {
                MappingKey mappingKey;
                try {
                    Integer id = Integer.valueOf(matcher.group("namespaced"));
                    mappingKey = NumericMappingKey.of(id);
                }
                catch (Throwable ignored) {
                    mappingKey = NamespacedMappingKey.of(matcher.group("namespaced"));
                }
                String duration_str = matcher.group("duration");
                if (PotionEffectMapping.potionEffectMapping.mapping.containsKey(mappingKey)) {
                    if (duration_str != null && !duration_str.isEmpty()) {
                        int duration;
                        try {
                            duration = Integer.parseInt(duration_str);
                        }
                        catch (Throwable t) {
                            duration = RomanToDecimal.romanToDecimal(duration_str);
                        }
                        return Optional.of(((PotionEffectHolder)PotionEffectMapping.potionEffectMapping.mapping.get(mappingKey)).withDuration(duration));
                    }
                    return Optional.of((PotionEffectHolder)PotionEffectMapping.potionEffectMapping.mapping.get(mappingKey));
                }
            }
            return Optional.empty();
        });
    }

    @OfMethodAlternative(value=PotionEffectHolder.class, methodName="all")
    public static List<PotionEffectHolder> getValues() {
        if (potionEffectMapping == null) {
            throw new UnsupportedOperationException("PotionEffectMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(PotionEffectMapping.potionEffectMapping.values);
    }

    protected PotionEffectMapping() {
        if (potionEffectMapping != null) {
            throw new UnsupportedOperationException("PotionEffect mapping is already initialized.");
        }
        potionEffectMapping = this;
    }

    @OnPostConstruct
    public void legacyMapping() {
        this.mapAlias("SLOWNESS", "SLOW");
        this.mapAlias("HASTE", "FAST_DIGGING");
        this.mapAlias("MINING_FATIGUE", "SLOW_DIGGING");
        this.mapAlias("STRENGTH", "INCREASE_DAMAGE");
        this.mapAlias("INSTANT_HEALTH", "HEAL");
        this.mapAlias("INSTANT_DAMAGE", "HARM");
        this.mapAlias("JUMP_BOOST", "JUMP");
        this.mapAlias("NAUSEA", "CONFUSION");
        this.mapAlias("RESISTANCE", "DAMAGE_RESISTANCE");
    }
}

