/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item.meta;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.PotionHolderSerializer;
import io.github.pronze.lib.screaminglib.item.meta.PotionHolder;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostConstruct;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<subPackage>[^\\.]+\\.[^\\.]+)\\.(?<className>.+)$")
public abstract class PotionMapping
extends AbstractTypeMapper<PotionHolder> {
    private static PotionMapping potionMapping;
    protected BidirectionalConverter<PotionHolder> potionConverter = BidirectionalConverter.build().registerP2W(PotionHolder.class, e -> e).registerP2W(ConfigurationNode.class, node -> {
        try {
            return PotionHolderSerializer.INSTANCE.deserialize((Type)((Object)PotionHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException e) {
            e.printStackTrace();
            return null;
        }
    });

    protected PotionMapping() {
        if (potionMapping != null) {
            throw new UnsupportedOperationException("Potion mapping is already initialized.");
        }
        potionMapping = this;
    }

    @OnPostConstruct
    public void bukkit2minecraftMapping() {
        this.mapAlias("EMPTY", "UNCRAFTABLE");
        this.mapAlias("LEAPING", "JUMP");
        this.mapAlias("SWIFTNESS", "SPEED");
        this.mapAlias("HEALING", "INSTANT_HEAL");
        this.mapAlias("HARMING", "INSTANT_DAMAGE");
        this.mapAlias("REGENERATION", "REGEN");
    }

    @Override
    protected void mapAlias(String potion, String potionBukkit) {
        if (potion == null || potionBukkit == null) {
            throw new IllegalArgumentException("Both potions mustn't be null!");
        }
        super.mapAlias(potion, potionBukkit);
        super.mapAlias("long_" + potion, "long_" + potionBukkit);
        super.mapAlias("strong_" + potion, "strong_" + potionBukkit);
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION)
    @OfMethodAlternative(value=PotionHolder.class, methodName="ofOptional")
    public static Optional<PotionHolder> resolve(Object potionObject) {
        if (potionMapping == null) {
            throw new UnsupportedOperationException("Potion mapping is not initialized yet.");
        }
        if (potionObject == null) {
            return Optional.empty();
        }
        return PotionMapping.potionMapping.potionConverter.convertOptional(potionObject).or(() -> potionMapping.resolveFromMapping(potionObject));
    }

    @OfMethodAlternative(value=PotionHolder.class, methodName="all")
    public static List<PotionHolder> getValues() {
        if (potionMapping == null) {
            throw new UnsupportedOperationException("PotionMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(PotionMapping.potionMapping.values);
    }
}

