/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.lang;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.lang.Lang;
import io.github.pronze.lib.screaminglib.lang.container.TranslationContainer;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public abstract class LangService {
    protected final Map<Locale, TranslationContainer> containers = new ConcurrentHashMap<Locale, TranslationContainer>();
    protected TranslationContainer fallbackContainer = TranslationContainer.empty();

    public Optional<TranslationContainer> getFor(Locale locale) {
        return Optional.ofNullable(this.containers.get(locale));
    }

    public TranslationContainer getFor(CommandSenderWrapper sender) {
        if (this.containers.isEmpty() || sender == null) {
            return this.fallbackContainer;
        }
        Locale senderLocale = this.resolveLocale(sender);
        TranslationContainer container = this.containers.get(senderLocale);
        if (container != null) {
            return container;
        }
        return this.containers.entrySet().stream().filter(entry -> ((Locale)entry.getKey()).getLanguage().equals(senderLocale.getLanguage())).map(Map.Entry::getValue).findAny().orElse(this.fallbackContainer);
    }

    public Component getDefaultPrefix() {
        return Lang.getDefaultPrefix();
    }

    @NotNull
    public Component resolvePrefix(@NotNull CommandSenderWrapper sender) {
        return Lang.getDefaultPrefix();
    }

    @NotNull
    protected Locale resolveLocale(@NotNull CommandSenderWrapper sender) {
        return sender.getLocale();
    }

    public void setFallbackContainer(TranslationContainer fallbackContainer) {
        this.fallbackContainer = fallbackContainer;
    }

    public TranslationContainer getFallbackContainer() {
        return this.fallbackContainer;
    }
}

